/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.utils.management;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import org.apache.aries.application.Content;
import org.apache.aries.application.impl.ContentImpl;
import org.apache.aries.application.management.BundleInfo;
import org.apache.aries.application.utils.manifest.BundleManifest;
import org.apache.aries.application.utils.manifest.ManifestHeaderProcessor;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleBundleInfo
implements BundleInfo {
    private Content _contentName;
    private Version _version;
    private Attributes _attributes;
    private Set<Content> _exportPackages = null;
    private Set<Content> _importPackages = null;
    private Set<Content> _exportServices = null;
    private Set<Content> _importServices = null;
    private Set<Content> _requireBundle = null;
    private String _location;

    public SimpleBundleInfo(BundleManifest bm, String location) {
        this._contentName = new ContentImpl(bm.getSymbolicName(), ManifestHeaderProcessor.parseBundleSymbolicName(bm.getSymbolicName()).getValue());
        this._version = bm.getVersion();
        this._attributes = bm.getRawAttributes();
        this._location = location;
    }

    public Set<Content> getExportPackage() {
        if (this._exportPackages == null) {
            this._exportPackages = this.getContentSetFromHeader(this._attributes, "Export-Package");
        }
        return this._exportPackages;
    }

    public Set<Content> getExportService() {
        if (this._exportServices == null) {
            this._exportServices = this.getContentSetFromHeader(this._attributes, "Export-Service");
        }
        return this._exportPackages;
    }

    public Map<String, String> getHeaders() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<Object, Object> h : this._attributes.entrySet()) {
            Attributes.Name name = (Attributes.Name)h.getKey();
            String value = (String)h.getValue();
            result.put(name.toString(), value);
        }
        return result;
    }

    public Set<Content> getImportPackage() {
        if (this._importPackages == null) {
            this._importPackages = this.getContentSetFromHeader(this._attributes, "Import-Package");
        }
        return this._importPackages;
    }

    public Set<Content> getImportService() {
        if (this._importServices == null) {
            this._importServices = this.getContentSetFromHeader(this._attributes, "Import-Service");
        }
        return this._importServices;
    }

    public String getLocation() {
        return this._location;
    }

    public String getSymbolicName() {
        return this._contentName.getContentName();
    }

    public Version getVersion() {
        return this._version;
    }

    private Set<Content> getContentSetFromHeader(Attributes attributes, String key) {
        String header = this._attributes.getValue(key);
        List<String> splitHeader = ManifestHeaderProcessor.split(header, ",");
        HashSet<Content> result = new HashSet<Content>();
        for (String s : splitHeader) {
            ContentImpl c = new ContentImpl(s);
            result.add(c);
        }
        return result;
    }

    public Map<String, String> getBundleAttributes() {
        return this._contentName.getAttributes();
    }

    public Map<String, String> getBundleDirectives() {
        return this._contentName.getDirectives();
    }

    public Set<Content> getRequireBundle() {
        if (this._requireBundle == null) {
            this._requireBundle = this.getContentSetFromHeader(this._attributes, "Require-Bundle");
        }
        return this._requireBundle;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other instanceof SimpleBundleInfo) {
            return this._location.equals(((SimpleBundleInfo)other)._location);
        }
        return false;
    }

    public int hashCode() {
        return this._location.hashCode();
    }

    public String toString() {
        return this._contentName.getContentName() + "_" + this.getVersion();
    }

    public Attributes getRawAttributes() {
        return this._attributes;
    }
}

