/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.whiteboard.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.apache.aries.component.dsl.OSGi;
import org.apache.aries.component.dsl.OSGiResult;
import org.apache.aries.component.dsl.internal.ConcurrentDoublyLinkedList;
import org.apache.aries.jax.rs.whiteboard.internal.FilteredPublisher;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public class Registry<T>
implements AutoCloseable {
    private final HashSet<FilteredPublisher<T>> _publishers = new HashSet();
    private final ConcurrentDoublyLinkedList<ServiceWithProperties<T>> _servicesWithPropertiesList = new ConcurrentDoublyLinkedList();

    @Override
    public void close() {
        for (FilteredPublisher<T> publisher : new HashSet<FilteredPublisher<T>>(this._publishers)) {
            publisher.close();
        }
    }

    public OSGi<T> waitForService(String filterString) {
        Filter filter;
        try {
            filter = FrameworkUtil.createFilter((String)filterString);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException();
        }
        return OSGi.fromOsgiRunnable((bc, p) -> {
            Registry registry = this;
            synchronized (registry) {
                FilteredPublisher ep = new FilteredPublisher(p, filter);
                this._publishers.add(ep);
                for (ServiceWithProperties<T> serviceWithProperties : new ArrayList<ServiceWithProperties<T>>(this._servicesWithPropertiesList)) {
                    ep.publishIfMatched(serviceWithProperties.service, serviceWithProperties.properties);
                }
                return () -> {
                    Registry registry = this;
                    synchronized (registry) {
                        this._publishers.remove(ep);
                        for (ServiceWithProperties<T> serviceWithProperties : new ArrayList<ServiceWithProperties<T>>(this._servicesWithPropertiesList)) {
                            ep.retract(serviceWithProperties.service);
                        }
                    }
                };
            }
        });
    }

    public OSGi<T> registerService(T service, Map<String, ?> properties) {
        return (bc, p) -> {
            Registry registry = this;
            synchronized (registry) {
                ConcurrentDoublyLinkedList.Node node = this._servicesWithPropertiesList.addLast(new ServiceWithProperties<Object>(service, properties));
                OSGiResult result = p.publish(service);
                for (FilteredPublisher<Object> filteredPublisher : new HashSet<FilteredPublisher<T>>(this._publishers)) {
                    filteredPublisher.publishIfMatched(service, properties);
                }
                return () -> {
                    Registry registry = this;
                    synchronized (registry) {
                        for (FilteredPublisher<Object> filteredPublisher : new HashSet<FilteredPublisher<T>>(this._publishers)) {
                            filteredPublisher.retract(service);
                        }
                        result.close();
                        node.remove();
                    }
                };
            }
        };
    }

    private static class ServiceWithProperties<T> {
        T service;
        Map<String, ?> properties;

        ServiceWithProperties(T service, Map<String, ?> properties) {
            this.service = service;
            this.properties = properties;
        }
    }
}

