/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.blueprint;

import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.aries.blueprint.Namespaces;
import org.apache.aries.blueprint.ParserContext;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.helpers.BaseNamespaceHandler;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.blueprint.JAXRSServerFactoryBeanDefinitionParser;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.apache.cxf.staxutils.transform.OutTransformWriter;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Namespaces(value={"http://cxf.apache.org/blueprint/jaxrs"})
public class JAXRSBPNamespaceHandler
extends BaseNamespaceHandler {
    private BlueprintContainer blueprintContainer;

    public URL getSchemaLocation(String namespace) {
        if ("http://cxf.apache.org/blueprint/jaxrs".equals(namespace) || "http://cxf.apache.org/schemas/jaxrs.xsd".equals(namespace)) {
            return this.getClass().getClassLoader().getResource("schemas/blueprint/jaxrs.xsd");
        }
        if ("http://cxf.apache.org/schemas/jaxrs-common.xsd".equals(namespace)) {
            return this.getClass().getClassLoader().getResource("schemas/blueprint/jaxrs-common.xsd");
        }
        return super.findCoreSchemaLocation(namespace);
    }

    public Metadata parse(Element element, ParserContext context) {
        String s = element.getLocalName();
        if ("server".equals(s)) {
            return new JAXRSServerFactoryBeanDefinitionParser().parse(element, context);
        }
        if ("client".equals(s)) {
            return (Metadata)context.parseElement(Metadata.class, null, this.transformElement(element));
        }
        return null;
    }

    public Set<Class> getManagedClasses() {
        return null;
    }

    public ComponentMetadata decorate(Node node, ComponentMetadata component, ParserContext context) {
        return null;
    }

    private Element transformElement(Element element) {
        Map<String, String> transformMap = Collections.singletonMap("{" + element.getNamespaceURI() + "}*", "{http://cxf.apache.org/blueprint/jaxrs-client}*");
        W3CDOMStreamWriter domWriter = new W3CDOMStreamWriter();
        OutTransformWriter transformWriter = new OutTransformWriter(domWriter, transformMap);
        try {
            StaxUtils.copy(element, (XMLStreamWriter)transformWriter);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        return domWriter.getDocument().getDocumentElement();
    }

    public BlueprintContainer getBlueprintContainer() {
        return this.blueprintContainer;
    }

    public void setBlueprintContainer(BlueprintContainer blueprintContainer) {
        this.blueprintContainer = blueprintContainer;
    }

    @NoJSR250Annotations
    public static class BPJAXRSServerFactoryBean
    extends JAXRSServerFactoryBean {
        private Server server;

        public BPJAXRSServerFactoryBean() {
        }

        public BPJAXRSServerFactoryBean(JAXRSServiceFactoryBean fact) {
            super(fact);
        }

        @Override
        public Server getServer() {
            return this.server;
        }

        @Override
        public void init() {
            this.create();
        }

        @Override
        public Server create() {
            if (this.server == null) {
                this.server = super.create();
            }
            return this.server;
        }

        public void destroy() {
            if (this.server != null) {
                this.server.destroy();
                this.server = null;
            }
        }
    }
}

