/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.access.ExternalTransaction;
import org.apache.cayenne.access.QueryLogger;
import org.apache.cayenne.access.TransactionDelegate;

class InternalTransaction
extends ExternalTransaction {
    InternalTransaction(TransactionDelegate delegate) {
        super(delegate);
    }

    public void begin() {
        super.begin();
        QueryLogger.logBeginTransaction("transaction started.");
    }

    void fixConnectionState(Connection connection) throws SQLException {
        if (connection.getAutoCommit()) {
            try {
                connection.setAutoCommit(false);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    void processCommit() throws SQLException, CayenneException {
        this.status = 2;
        if (this.connections != null && this.connections.size() > 0) {
            Throwable deferredException = null;
            for (Connection connection : this.connections.values()) {
                try {
                    if (deferredException == null) {
                        connection.commit();
                        continue;
                    }
                    connection.rollback();
                }
                catch (Throwable th) {
                    this.setRollbackOnly();
                    deferredException = th;
                }
            }
            if (deferredException != null) {
                QueryLogger.logRollbackTransaction("transaction rolledback.");
                if (deferredException instanceof SQLException) {
                    throw (SQLException)deferredException;
                }
                throw new CayenneException(deferredException);
            }
            QueryLogger.logCommitTransaction("transaction committed.");
        }
    }

    void processRollback() throws SQLException, CayenneException {
        this.status = 5;
        if (this.connections != null && this.connections.size() > 0) {
            Throwable deferredException = null;
            for (Connection connection : this.connections.values()) {
                try {
                    connection.rollback();
                }
                catch (Throwable th) {
                    deferredException = th;
                }
            }
            if (deferredException != null) {
                if (deferredException instanceof SQLException) {
                    throw (SQLException)deferredException;
                }
                throw new CayenneException(deferredException);
            }
        }
    }
}

