/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Policy;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.jar.JarFile;
import org.apache.felix.framework.util.JarFileX;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class SecureAction {
    private static final ThreadLocal m_actions = new ThreadLocal(){

        public Object initialValue() {
            return new Actions();
        }
    };
    protected static transient int BUFSIZE = 4096;
    private AccessControlContext m_acc = AccessController.getContext();
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$net$URLClassLoader;
    static /* synthetic */ Class class$java$util$Hashtable;

    public String getSystemProperty(String name, String def) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(0, name, def);
                return (String)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getException();
            }
        }
        return System.getProperty(name, def);
    }

    public Class forName(String name) throws ClassNotFoundException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(1, name);
                return (Class)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)ex.getException();
                }
                throw (RuntimeException)ex.getException();
            }
        }
        return Class.forName(name);
    }

    public URL createURL(String protocol, String host, int port, String path, URLStreamHandler handler) throws MalformedURLException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(2, protocol, host, new Integer(port), path, handler);
                return (URL)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof MalformedURLException) {
                    throw (MalformedURLException)ex.getException();
                }
                throw (RuntimeException)ex.getException();
            }
        }
        return new URL(protocol, host, port, path, handler);
    }

    public URL createURL(URL context, String spec, URLStreamHandler handler) throws MalformedURLException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(3, context, spec, handler);
                return (URL)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof MalformedURLException) {
                    throw (MalformedURLException)ex.getException();
                }
                throw (RuntimeException)ex.getException();
            }
        }
        return new URL(context, spec, handler);
    }

    public String getAbsolutePath(File file) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(4, file);
                return (String)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getException();
            }
        }
        return file.getAbsolutePath();
    }

    public boolean fileExists(File file) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(5, file);
                return (Boolean)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getException();
            }
        }
        return file.exists();
    }

    public boolean isFileDirectory(File file) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(6, file);
                return (Boolean)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getException();
            }
        }
        return file.isDirectory();
    }

    public boolean mkdir(File file) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(7, file);
                return (Boolean)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getException();
            }
        }
        return file.mkdir();
    }

    public boolean mkdirs(File file) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(8, file);
                return (Boolean)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getException();
            }
        }
        return file.mkdirs();
    }

    public File[] listDirectory(File file) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(9, file);
                return (File[])AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getException();
            }
        }
        return file.listFiles();
    }

    public boolean renameFile(File oldFile, File newFile) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(10, oldFile, newFile);
                return (Boolean)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getException();
            }
        }
        return oldFile.renameTo(newFile);
    }

    public InputStream getFileInputStream(File file) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(11, file);
                return (InputStream)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof IOException) {
                    throw (IOException)ex.getException();
                }
                throw (RuntimeException)ex.getException();
            }
        }
        return new FileInputStream(file);
    }

    public OutputStream getFileOutputStream(File file) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(12, file);
                return (OutputStream)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof IOException) {
                    throw (IOException)ex.getException();
                }
                throw (RuntimeException)ex.getException();
            }
        }
        return new FileOutputStream(file);
    }

    public InputStream getURLConnectionInputStream(URLConnection conn) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(15, conn);
                return (InputStream)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof IOException) {
                    throw (IOException)ex.getException();
                }
                throw (RuntimeException)ex.getException();
            }
        }
        return conn.getInputStream();
    }

    public boolean deleteFile(File target) {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(13, target);
                return (Boolean)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getException();
            }
        }
        return target.delete();
    }

    public File createTempFile(String prefix, String suffix, File dir) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(22, prefix, suffix, dir);
                return (File)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof IOException) {
                    throw (IOException)ex.getException();
                }
                throw (RuntimeException)ex.getException();
            }
        }
        return File.createTempFile(prefix, suffix, dir);
    }

    public URLConnection openURLConnection(URL url) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(23, url);
                return (URLConnection)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof IOException) {
                    throw (IOException)ex.getException();
                }
                throw (RuntimeException)ex.getException();
            }
        }
        return url.openConnection();
    }

    public JarFile getJarURLConnectionJAR(JarURLConnection connection) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(24, connection);
                return (JarFile)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof IOException) {
                    throw (IOException)ex.getException();
                }
                throw (RuntimeException)ex.getException();
            }
        }
        return connection.getJarFile();
    }

    public JarFileX openJAR(File file) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(14, file);
                return (JarFileX)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof IOException) {
                    throw (IOException)ex.getException();
                }
                throw (RuntimeException)ex.getException();
            }
        }
        return new JarFileX(file);
    }

    public JarFileX openJAR(File file, boolean verify) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(20, file, verify ? Boolean.TRUE : Boolean.FALSE);
                return (JarFileX)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                if (ex.getException() instanceof IOException) {
                    throw (IOException)ex.getException();
                }
                throw (RuntimeException)ex.getException();
            }
        }
        return new JarFileX(file);
    }

    public void startActivator(BundleActivator activator, BundleContext context) throws Exception {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(17, activator, context);
                AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw ex.getException();
            }
        } else {
            activator.start(context);
        }
    }

    public void stopActivator(BundleActivator activator, BundleContext context) throws Exception {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(18, activator, context);
                AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw ex.getException();
            }
        } else {
            activator.stop(context);
        }
    }

    public Policy getPolicy() {
        if (System.getSecurityManager() != null) {
            try {
                Actions actions = (Actions)m_actions.get();
                actions.set(21, null);
                return (Policy)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getException();
            }
        }
        return Policy.getPolicy();
    }

    public void addURLToURLClassLoader(URL extension, ClassLoader loader) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(25, extension, loader);
            try {
                AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        } else {
            Method addURL = (class$java$net$URLClassLoader == null ? (class$java$net$URLClassLoader = SecureAction.class$("java.net.URLClassLoader")) : class$java$net$URLClassLoader).getDeclaredMethod("addURL", class$java$net$URL == null ? (class$java$net$URL = SecureAction.class$("java.net.URL")) : class$java$net$URL);
            addURL.setAccessible(true);
            addURL.invoke((Object)loader, extension);
        }
    }

    public Constructor getConstructor(Class target, Class[] types) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(26, target, types);
            try {
                return (Constructor)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
        return target.getConstructor(types);
    }

    public Method getMethod(Class target, String method, Class[] types) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(27, target, method, types);
            try {
                return (Method)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
        return target.getMethod(method, types);
    }

    public Method getDeclaredMethod(Class target, String method, Class[] types) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(32, target, method, types);
            try {
                return (Method)AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
        return target.getDeclaredMethod(method, types);
    }

    public void setAccesssible(Method method) {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(33, method);
            try {
                AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException e) {
                throw (RuntimeException)e.getException();
            }
        } else {
            method.setAccessible(true);
        }
    }

    public Object invoke(Method method, Object target, Object[] params) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(28, method, target, params);
            try {
                return AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
        method.setAccessible(true);
        return method.invoke(target, params);
    }

    public Object invokeDirect(Method method, Object target, Object[] params) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(34, method, target, params);
            try {
                return AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
        return method.invoke(target, params);
    }

    public Object invoke(Constructor constructor, Object[] params) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(29, constructor, params);
            try {
                return AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
        return constructor.newInstance(params);
    }

    public Object getDeclaredField(Class targetClass, String name, Object target) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(31, targetClass, name, target);
            try {
                return AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
        Field field = targetClass.getDeclaredField(name);
        field.setAccessible(true);
        return field.get(target);
    }

    public Object swapStaticFieldIfNotClass(Class targetClazz, Class targetType, Class condition, String lockName) throws Exception {
        if (System.getSecurityManager() != null) {
            Actions actions = (Actions)m_actions.get();
            actions.set(30, targetClazz, targetType, condition, lockName);
            try {
                return AccessController.doPrivileged(actions, this.m_acc);
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
        return SecureAction._swapStaticFieldIfNotClass(targetClazz, targetType, condition, lockName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object _swapStaticFieldIfNotClass(Class targetClazz, Class targetType, Class condition, String lockName) throws Exception {
        Object lock = null;
        if (lockName != null) {
            try {
                Field lockField = targetClazz.getDeclaredField(lockName);
                lockField.setAccessible(true);
                lock = lockField.get(null);
            }
            catch (NoSuchFieldException ex) {
                // empty catch block
            }
        }
        if (lock == null) {
            lock = targetClazz;
        }
        Class clazz = lock;
        synchronized (clazz) {
            int i;
            Field[] fields = targetClazz.getDeclaredFields();
            Object result = null;
            for (i = 0; i < fields.length && result == null; ++i) {
                if (!Modifier.isStatic(fields[i].getModifiers()) || fields[i].getType() != targetType) continue;
                fields[i].setAccessible(true);
                result = fields[i].get(null);
                if (result == null || condition != null && result.getClass().getName().equals(condition.getName())) continue;
                fields[i].set(null, null);
            }
            if (result != null) {
                if (condition == null || !result.getClass().getName().equals(condition.getName())) {
                    for (i = 0; i < fields.length; ++i) {
                        if (!Modifier.isStatic(fields[i].getModifiers()) || fields[i].getType() != (class$java$util$Hashtable == null ? SecureAction.class$("java.util.Hashtable") : class$java$util$Hashtable)) continue;
                        fields[i].setAccessible(true);
                        Hashtable cache = (Hashtable)fields[i].get(null);
                        if (cache == null) continue;
                        cache.clear();
                    }
                }
                return result;
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Actions
    implements PrivilegedExceptionAction {
        public static final int GET_PROPERTY_ACTION = 0;
        public static final int FOR_NAME_ACTION = 1;
        public static final int CREATE_URL_ACTION = 2;
        public static final int CREATE_URL_WITH_CONTEXT_ACTION = 3;
        public static final int GET_ABSOLUTE_PATH_ACTION = 4;
        public static final int FILE_EXISTS_ACTION = 5;
        public static final int FILE_IS_DIRECTORY_ACTION = 6;
        public static final int MAKE_DIRECTORY_ACTION = 7;
        public static final int MAKE_DIRECTORIES_ACTION = 8;
        public static final int LIST_DIRECTORY_ACTION = 9;
        public static final int RENAME_FILE_ACTION = 10;
        public static final int GET_FILE_INPUT_ACTION = 11;
        public static final int GET_FILE_OUTPUT_ACTION = 12;
        public static final int DELETE_FILE_ACTION = 13;
        public static final int OPEN_JARX_ACTION = 14;
        public static final int GET_URL_INPUT_ACTION = 15;
        public static final int CREATE_MODULECLASSLOADER_ACTION = 16;
        public static final int START_ACTIVATOR_ACTION = 17;
        public static final int STOP_ACTIVATOR_ACTION = 18;
        public static final int SYSTEM_EXIT_ACTION = 19;
        public static final int OPEN_JARX_VERIFY_ACTION = 20;
        public static final int GET_POLICY_ACTION = 21;
        public static final int CREATE_TMPFILE_ACTION = 22;
        public static final int OPEN_URLCONNECTION_ACTION = 23;
        public static final int OPEN_JARURLCONNECTIONJAR_ACTION = 24;
        public static final int ADD_EXTENSION_URL = 25;
        public static final int GET_CONSTRUCTOR_ACTION = 26;
        public static final int GET_METHOD_ACTION = 27;
        public static final int INVOKE_METHOD_ACTION = 28;
        public static final int INVOKE_CONSTRUCTOR_ACTION = 29;
        public static final int SWAP_FIELD_ACTION = 30;
        public static final int GET_FIELD_ACTION = 31;
        public static final int GET_DECLAREDMETHOD_ACTION = 32;
        public static final int SET_ACCESSIBLE_ACTION = 33;
        public static final int INVOKE_DIRECTMETHOD_ACTION = 34;
        private int m_action = -1;
        private Object m_arg1 = null;
        private Object m_arg2 = null;
        private Object m_arg3 = null;
        private Object m_arg4 = null;
        private Object m_arg5 = null;

        private Actions() {
        }

        public void set(int action, Object arg1) {
            this.m_action = action;
            this.m_arg1 = arg1;
        }

        public void set(int action, Object arg1, Object arg2) {
            this.m_action = action;
            this.m_arg1 = arg1;
            this.m_arg2 = arg2;
        }

        public void set(int action, Object arg1, Object arg2, Object arg3) {
            this.m_action = action;
            this.m_arg1 = arg1;
            this.m_arg2 = arg2;
            this.m_arg3 = arg3;
        }

        public void set(int action, Object arg1, Object arg2, Object arg3, Object arg4) {
            this.m_action = action;
            this.m_arg1 = arg1;
            this.m_arg2 = arg2;
            this.m_arg3 = arg3;
            this.m_arg4 = arg4;
        }

        public void set(int action, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
            this.m_action = action;
            this.m_arg1 = arg1;
            this.m_arg2 = arg2;
            this.m_arg3 = arg3;
            this.m_arg4 = arg4;
            this.m_arg5 = arg5;
        }

        private void unset() {
            this.m_action = -1;
            this.m_arg1 = null;
            this.m_arg2 = null;
            this.m_arg3 = null;
            this.m_arg4 = null;
            this.m_arg5 = null;
        }

        public Object run() throws Exception {
            int action = this.m_action;
            Object arg1 = this.m_arg1;
            Object arg2 = this.m_arg2;
            Object arg3 = this.m_arg3;
            Object arg4 = this.m_arg4;
            Object arg5 = this.m_arg5;
            this.unset();
            if (action == 0) {
                return System.getProperty((String)arg1, (String)arg2);
            }
            if (action == 1) {
                return Class.forName((String)arg1);
            }
            if (action == 2) {
                return new URL((String)arg1, (String)arg2, (Integer)arg3, (String)arg4, (URLStreamHandler)arg5);
            }
            if (action == 3) {
                return new URL((URL)arg1, (String)arg2, (URLStreamHandler)arg3);
            }
            if (action == 4) {
                return ((File)arg1).getAbsolutePath();
            }
            if (action == 5) {
                return ((File)arg1).exists() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (action == 6) {
                return ((File)arg1).isDirectory() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (action == 7) {
                return ((File)arg1).mkdir() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (action == 8) {
                return ((File)arg1).mkdirs() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (action == 9) {
                return ((File)arg1).listFiles();
            }
            if (action == 10) {
                return ((File)arg1).renameTo((File)arg2) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (action == 11) {
                return new FileInputStream((File)arg1);
            }
            if (action == 12) {
                return new FileOutputStream((File)arg1);
            }
            if (action == 13) {
                return ((File)arg1).delete() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (action == 14) {
                return new JarFileX((File)arg1);
            }
            if (action == 20) {
                return new JarFile((File)arg1, (boolean)((Boolean)arg2));
            }
            if (action == 15) {
                return ((URLConnection)arg1).getInputStream();
            }
            if (action == 17) {
                ((BundleActivator)arg1).start((BundleContext)arg2);
                return null;
            }
            if (action == 18) {
                ((BundleActivator)arg1).stop((BundleContext)arg2);
                return null;
            }
            if (action == 19) {
                System.exit((Integer)arg1);
            } else {
                if (action == 21) {
                    return Policy.getPolicy();
                }
                if (action == 22) {
                    return File.createTempFile((String)arg1, (String)arg2, (File)arg3);
                }
                if (action == 23) {
                    return ((URL)arg1).openConnection();
                }
                if (action == 24) {
                    return ((JarURLConnection)arg1).getJarFile();
                }
                if (action == 25) {
                    Method addURL = (class$java$net$URLClassLoader == null ? (class$java$net$URLClassLoader = SecureAction.class$("java.net.URLClassLoader")) : class$java$net$URLClassLoader).getDeclaredMethod("addURL", class$java$net$URL == null ? (class$java$net$URL = SecureAction.class$("java.net.URL")) : class$java$net$URL);
                    addURL.setAccessible(true);
                    addURL.invoke(arg2, arg1);
                } else {
                    if (action == 26) {
                        return ((Class)arg1).getConstructor((Class[])arg2);
                    }
                    if (action == 27) {
                        return ((Class)arg1).getMethod((String)arg2, (Class[])arg3);
                    }
                    if (action == 28) {
                        ((Method)arg1).setAccessible(true);
                        return ((Method)arg1).invoke(arg2, (Object[])arg3);
                    }
                    if (action == 34) {
                        return ((Method)arg1).invoke(arg2, (Object[])arg3);
                    }
                    if (action == 29) {
                        return ((Constructor)arg1).newInstance((Object[])arg2);
                    }
                    if (action == 30) {
                        return SecureAction._swapStaticFieldIfNotClass((Class)arg1, (Class)arg2, (Class)arg3, (String)arg4);
                    }
                    if (action == 31) {
                        Field field = ((Class)arg1).getDeclaredField((String)arg2);
                        field.setAccessible(true);
                        return field.get(arg3);
                    }
                    if (action == 32) {
                        return ((Class)arg1).getDeclaredMethod((String)arg2, (Class[])arg3);
                    }
                    if (action == 33) {
                        ((Method)arg1).setAccessible(true);
                    }
                }
            }
            return null;
        }
    }
}

