/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.tags.cl;

import java.util.HashMap;
import java.util.Map;
import org.apache.felix.scrplugin.om.Interface;
import org.apache.felix.scrplugin.om.Property;
import org.apache.felix.scrplugin.om.Reference;
import org.apache.felix.scrplugin.tags.JavaClassDescription;
import org.apache.felix.scrplugin.tags.JavaField;
import org.apache.felix.scrplugin.tags.JavaTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderJavaTag
implements JavaTag {
    protected final JavaClassDescription description;
    protected final Reference reference;
    protected final Property property;
    protected final Interface interf;
    protected boolean isServiceFactory;

    public ClassLoaderJavaTag(JavaClassDescription desc, Reference reference) {
        this.description = desc;
        this.reference = reference;
        this.interf = null;
        this.property = null;
    }

    public ClassLoaderJavaTag(JavaClassDescription desc, Property property) {
        this.description = desc;
        this.property = property;
        this.reference = null;
        this.interf = null;
    }

    public ClassLoaderJavaTag(JavaClassDescription desc, Interface i, boolean isSF) {
        this.interf = i;
        this.description = desc;
        this.property = null;
        this.reference = null;
        this.isServiceFactory = isSF;
    }

    @Override
    public JavaField getField() {
        return null;
    }

    @Override
    public JavaClassDescription getJavaClassDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        if (this.reference != null) {
            return "scr.reference";
        }
        if (this.property != null) {
            return "scr.property";
        }
        if (this.interf != null) {
            return "scr.service";
        }
        return null;
    }

    @Override
    public String getNamedParameter(String name) {
        Map<String, String> map = this.getNamedParameterMap();
        if (map != null) {
            return map.get(name);
        }
        return null;
    }

    @Override
    public Map<String, String> getNamedParameterMap() {
        if (this.reference != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("bind", this.reference.getBind());
            map.put("cardinality", this.reference.getCardinality());
            map.put("interface", this.reference.getInterfacename());
            map.put("name", this.reference.getName());
            map.put("policy", this.reference.getPolicy());
            map.put("target", this.reference.getTarget());
            map.put("unbind", this.reference.getUnbind());
            map.put("checked", String.valueOf(this.reference.isChecked()));
            map.put("strategy", this.reference.getStrategy());
            return map;
        }
        if (this.property != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("type", this.property.getType());
            map.put("name", this.property.getName());
            String[] values = this.property.getMultiValue();
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    map.put("values." + i, values[i]);
                }
            } else {
                map.put("value", this.property.getValue());
            }
            map.put("private", String.valueOf(this.property.isPrivate()));
            if (this.property.getLabel() != null) {
                map.put("label", this.property.getLabel());
            }
            if (this.property.getDescription() != null) {
                map.put("description", this.property.getDescription());
            }
            if (this.property.getCardinality() != null) {
                map.put("cardinality", this.property.getCardinality());
            }
            return map;
        }
        if (this.interf != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("interface", this.interf.getInterfacename());
            if (this.isServiceFactory) {
                map.put("servicefactory", "true");
            }
            return map;
        }
        return null;
    }

    @Override
    public String[] getParameters() {
        Map<String, String> map = this.getNamedParameterMap();
        if (map != null) {
            return map.keySet().toArray(new String[5]);
        }
        return new String[0];
    }

    @Override
    public String getSourceLocation() {
        return "Compiled class: " + this.description.getName();
    }
}

