/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.runtime;

import java.util.List;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.ComponentStateListener;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.runtime.DependencyBuilder;
import org.apache.felix.dm.runtime.InvocationUtil;
import org.apache.felix.dm.runtime.Log;
import org.apache.felix.dm.runtime.MetaData;
import org.apache.felix.dm.runtime.Params;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBuilder {
    abstract String getType();

    abstract void build(MetaData var1, List<MetaData> var2, Bundle var3, DependencyManager var4) throws Exception;

    protected void setCommonServiceParams(Component c, MetaData srvMeta) throws Exception {
        String componentField;
        String dependencyManagerField;
        String bundleContextField;
        DependencyManager dm = c.getDependencyManager();
        boolean autoConfigureComponents = "true".equals(dm.getBundleContext().getProperty("dm.runtime.autoconfig"));
        if (!autoConfigureComponents) {
            c.setAutoConfig(BundleContext.class, Boolean.FALSE.booleanValue());
            c.setAutoConfig(ServiceRegistration.class, Boolean.FALSE.booleanValue());
            c.setAutoConfig(DependencyManager.class, Boolean.FALSE.booleanValue());
            c.setAutoConfig(Component.class, Boolean.FALSE.booleanValue());
        }
        if ((bundleContextField = srvMeta.getString(Params.bundleContextField, null)) != null) {
            c.setAutoConfig(BundleContext.class, bundleContextField);
        }
        if ((dependencyManagerField = srvMeta.getString(Params.dependencyManagerField, null)) != null) {
            c.setAutoConfig(DependencyManager.class, dependencyManagerField);
        }
        if ((componentField = srvMeta.getString(Params.componentField, null)) != null) {
            c.setAutoConfig(Component.class, componentField);
        }
        String registered = srvMeta.getString(Params.registered, null);
        String unregistered = srvMeta.getString(Params.unregistered, null);
        if (registered != null || unregistered != null) {
            c.addStateListener((ComponentStateListener)new RegistrationListener(registered, unregistered));
        }
    }

    protected static void addUnamedDependencies(Bundle b, DependencyManager dm, Component s, MetaData srvMeta, List<MetaData> depsMeta) throws Exception {
        for (MetaData dependency : depsMeta) {
            String name = dependency.getString(Params.name, null);
            if (name != null) continue;
            DependencyBuilder depBuilder = new DependencyBuilder(dependency);
            Log.instance().info("adding dependency %s into service %s", dependency, srvMeta);
            Dependency d = depBuilder.build(b, dm, false);
            s.add(d);
        }
    }

    static class RegistrationListener
    implements ComponentStateListener {
        private final String m_registered;
        private String m_unregistered;

        RegistrationListener(String registered, String unregistered) {
            this.m_registered = registered;
            this.m_unregistered = unregistered;
        }

        public void starting(Component c) {
        }

        public void started(Component c) {
            if (this.m_registered != null) {
                Object[] componentInstances;
                for (Object instance : componentInstances = c.getCompositionInstances()) {
                    try {
                        Class[][] signatures = new Class[][]{{ServiceRegistration.class}, new Class[0]};
                        Object[][] params = new Object[][]{{c.getServiceRegistration()}, new Object[0]};
                        InvocationUtil.invokeCallbackMethod(instance, this.m_registered, signatures, params);
                    }
                    catch (Throwable t) {
                        Log.instance().error("Exception caught while invoking method %s on component %s", t, this.m_registered, instance);
                    }
                }
            }
        }

        public void stopping(Component c) {
        }

        public void stopped(Component c) {
            if (this.m_unregistered != null) {
                Object instance = c.getService();
                try {
                    InvocationUtil.invokeCallbackMethod(instance, this.m_unregistered, new Class[][]{new Class[0]}, new Object[][]{new Object[0]});
                }
                catch (Throwable t) {
                    Log.instance().error("Exception caught while invoking method %s on component %s", t, this.m_registered, instance);
                }
            }
        }
    }
}

