/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.runtime;

import java.util.HashMap;
import java.util.Map;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyActivatorBase;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.TemporalServiceDependency;
import org.apache.felix.dm.runtime.DependencyManagerRuntime;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;
import org.osgi.service.packageadmin.PackageAdmin;

public class Activator
extends DependencyActivatorBase {
    static final String CONF_LOG = "dm.runtime.log";
    private static final String CONF_PACKAGE_ADMIN = "dm.runtime.packageAdmin";
    static final String CONF_ENABLE_AUTOCONFIG = "dm.runtime.autoconfig";

    public void init(BundleContext context, DependencyManager dm) throws Exception {
        Component component = this.createComponent().setImplementation(DependencyManagerRuntime.class).setComposition("getComposition").add((Dependency)this.createBundleDependency().setRequired(false).setAutoConfig(false).setStateMask(32).setFilter("(DependencyManager-Component=*)").setCallbacks("bundleStarted", "bundleStopped"));
        HashMap<String, Class> services = new HashMap<String, Class>(2);
        services.put(CONF_LOG, LogService.class);
        services.put(CONF_PACKAGE_ADMIN, PackageAdmin.class);
        for (Map.Entry entry : services.entrySet()) {
            String serviceProperty = (String)entry.getKey();
            Class service = (Class)entry.getValue();
            boolean serviceActive = "true".equalsIgnoreCase(context.getProperty(serviceProperty));
            TemporalServiceDependency serviceDep = serviceActive ? this.createTemporalServiceDependency() : this.createServiceDependency().setRequired(false);
            serviceDep.setService(service).setAutoConfig(true);
            component.add((Dependency)serviceDep);
        }
        dm.add(component);
    }

    public void destroy(BundleContext context, DependencyManager dm) throws Exception {
    }
}

