/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.runtime;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyActivation;
import org.apache.felix.dm.DependencyService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToggleServiceDependency
implements Dependency,
DependencyActivation {
    private final List<Object> m_services = new ArrayList<Object>();
    private volatile boolean m_isAvailable;
    private volatile boolean m_stopped;

    public ToggleServiceDependency() {
    }

    public ToggleServiceDependency(boolean isAvailable) {
        this.m_isAvailable = isAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAvailable(boolean isAvailable) {
        int i;
        Object[] services;
        ToggleServiceDependency toggleServiceDependency = this;
        synchronized (toggleServiceDependency) {
            if (this.m_stopped) {
                return;
            }
            boolean changed = this.m_isAvailable != isAvailable;
            this.m_isAvailable = isAvailable;
            if (!changed) {
                return;
            }
        }
        if (this.m_isAvailable) {
            services = this.m_services.toArray();
            for (i = 0; i < services.length; ++i) {
                DependencyService ds = (DependencyService)services[i];
                ds.dependencyAvailable((Dependency)this);
                if (this.isRequired()) continue;
                this.invokeAdded(ds);
            }
        } else {
            services = this.m_services.toArray();
            for (i = 0; i < services.length; ++i) {
                DependencyService ds = (DependencyService)services[i];
                ds.dependencyUnavailable((Dependency)this);
                if (this.isRequired()) continue;
                this.invokeRemoved(ds);
            }
        }
    }

    public Dependency createCopy() {
        return new ToggleServiceDependency(this.m_isAvailable);
    }

    public Object getAutoConfigInstance() {
        return "" + this.m_isAvailable;
    }

    public String getAutoConfigName() {
        return null;
    }

    public Class<?> getAutoConfigType() {
        return String.class;
    }

    public Dictionary getProperties() {
        return null;
    }

    public void invokeAdded(DependencyService service) {
    }

    public void invokeRemoved(DependencyService service) {
    }

    public void invoke(DependencyService dependencyService, String name) {
    }

    public boolean isAutoConfig() {
        return false;
    }

    public boolean isAvailable() {
        return this.m_isAvailable;
    }

    public boolean isInstanceBound() {
        return true;
    }

    public boolean isPropagated() {
        return false;
    }

    public boolean isRequired() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(DependencyService service) {
        ToggleServiceDependency toggleServiceDependency = this;
        synchronized (toggleServiceDependency) {
            this.m_services.add(service);
            this.m_stopped = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(DependencyService service) {
        ToggleServiceDependency toggleServiceDependency = this;
        synchronized (toggleServiceDependency) {
            this.m_services.remove(service);
            this.m_stopped = true;
        }
    }
}

