/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deployment.rp.autoconf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.felix.deployment.rp.autoconf.AutoConfResource;
import org.apache.felix.deployment.rp.autoconf.ObjectClassDefinitionImpl;
import org.apache.felix.deployment.rp.autoconf.PersistencyManager;
import org.apache.felix.metatype.Attribute;
import org.apache.felix.metatype.Designate;
import org.apache.felix.metatype.MetaData;
import org.apache.felix.metatype.MetaDataReader;
import org.apache.felix.metatype.OCD;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.deploymentadmin.spi.DeploymentSession;
import org.osgi.service.deploymentadmin.spi.ResourceProcessor;
import org.osgi.service.deploymentadmin.spi.ResourceProcessorException;
import org.osgi.service.log.LogService;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeService;
import org.osgi.service.metatype.ObjectClassDefinition;
import org.xmlpull.v1.XmlPullParserException;

public class AutoConfResourceProcessor
implements ResourceProcessor {
    private static final String LOCATION_PREFIX = "osgi-dp:";
    private volatile LogService m_log;
    private volatile ConfigurationAdmin m_configAdmin;
    private volatile MetaTypeService m_metaService;
    private volatile BundleContext m_bc;
    private DeploymentSession m_session = null;
    private Map m_toBeInstalled = new HashMap();
    private Map m_toBeDeleted = new HashMap();
    private PersistencyManager m_persistencyManager;

    public void start() throws IOException {
        File root = this.m_bc.getDataFile("");
        if (root == null) {
            throw new IOException("No file system support");
        }
        this.m_persistencyManager = new PersistencyManager(root);
    }

    public void begin(DeploymentSession session) {
        this.m_session = session;
    }

    public void process(String name, InputStream stream) throws ResourceProcessorException {
        if (this.m_session == null) {
            throw new ResourceProcessorException(463, "Can not process resource without a Deployment Session");
        }
        MetaDataReader reader = new MetaDataReader();
        MetaData data = null;
        try {
            data = reader.parse(stream);
        }
        catch (IOException e) {
            throw new ResourceProcessorException(463, "Unable to process resource.", e);
        }
        catch (XmlPullParserException e) {
            throw new ResourceProcessorException(463, "Supplied configuration is not conform the metatype xml specification.", e);
        }
        if (data == null) {
            throw new ResourceProcessorException(463, "Supplied configuration is not conform the metatype xml specification.");
        }
        Map designates = data.getDesignates();
        if (designates == null) {
            this.m_log.log(3, "No designates found in the resource, so there's nothing to process.");
            return;
        }
        Map localOcds = data.getObjectClassDefinitions();
        Iterator i = designates.keySet().iterator();
        while (i.hasNext()) {
            Designate designate = (Designate)designates.get(i.next());
            ObjectClassDefinition ocd = null;
            String ocdRef = designate.getObject().getOcdRef();
            OCD localOcd = (OCD)localOcds.get(ocdRef);
            ObjectClassDefinition objectClassDefinition = ocd = localOcd != null ? new ObjectClassDefinitionImpl(localOcd) : this.getMetaTypeOCD(data, designate);
            if (ocd == null) {
                throw new ResourceProcessorException(463, "No Object Class Definition found with id=" + ocdRef);
            }
            Dictionary dict = this.getProperties(designate, ocd);
            if (dict == null) continue;
            if (!this.m_toBeInstalled.containsKey(name)) {
                this.m_toBeInstalled.put(name, new ArrayList());
            }
            List resources = (List)this.m_toBeInstalled.get(name);
            resources.add(new AutoConfResource(name, designate.getPid(), designate.getFactoryPid(), designate.getBundleLocation(), designate.isMerge(), dict));
        }
    }

    public void dropped(String name) throws ResourceProcessorException {
        if (this.m_session == null) {
            throw new ResourceProcessorException(463, "Can not process resource without a Deployment Session");
        }
        try {
            List resources = this.m_persistencyManager.load(name);
            if (!this.m_toBeDeleted.containsKey(name)) {
                this.m_toBeDeleted.put(name, new ArrayList());
            }
            ((List)this.m_toBeDeleted.get(name)).addAll(resources);
        }
        catch (IOException ioe) {
            throw new ResourceProcessorException(463, "Unable to drop resource: " + name, ioe);
        }
    }

    public void dropAllResources() throws ResourceProcessorException {
        if (this.m_session == null) {
            throw new ResourceProcessorException(463, "Can not drop all resources without a Deployment Session");
        }
        try {
            Map loadAll = this.m_persistencyManager.loadAll();
            Iterator i = loadAll.keySet().iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                this.dropped(name);
            }
        }
        catch (IOException ioe) {
            throw new ResourceProcessorException(463, "Unable to drop all resources.", ioe);
        }
        File basedir = this.m_bc.getDataFile("");
        if (basedir != null && basedir.isDirectory()) {
            String[] files = basedir.list();
            for (int i = 0; i < files.length; ++i) {
                this.dropped(files[i]);
            }
        } else {
            throw new ResourceProcessorException(463, "Unable to drop resources, data area is not accessible");
        }
    }

    public void prepare() throws ResourceProcessorException {
        if (this.m_session == null) {
            throw new ResourceProcessorException(463, "Can not process resource without a Deployment Session");
        }
        try {
            String name;
            Iterator i = this.m_toBeDeleted.keySet().iterator();
            while (i.hasNext()) {
                name = (String)i.next();
                List resources = (List)this.m_toBeDeleted.get(name);
                Iterator j = resources.iterator();
                while (j.hasNext()) {
                    Configuration configuration;
                    AutoConfResource resource = (AutoConfResource)j.next();
                    if (resource.isFactoryConfig()) {
                        configuration = this.m_configAdmin.getConfiguration(resource.getGeneratedPid(), resource.getBundleLocation());
                        configuration.delete();
                        continue;
                    }
                    configuration = this.m_configAdmin.getConfiguration(resource.getPid(), resource.getBundleLocation());
                    configuration.delete();
                }
                this.m_persistencyManager.delete(name);
            }
            Iterator j = this.m_toBeInstalled.keySet().iterator();
            while (j.hasNext()) {
                name = (String)j.next();
                List existingResources = null;
                try {
                    existingResources = this.m_persistencyManager.load(name);
                }
                catch (IOException ioe) {
                    throw new ResourceProcessorException(1, "Unable to read existing resources for resource " + name, ioe);
                }
                List resources = (List)this.m_toBeInstalled.get(name);
                Iterator iterator = resources.iterator();
                while (iterator.hasNext()) {
                    Dictionary existingProperties;
                    AutoConfResource existingResource;
                    Iterator i2;
                    AutoConfResource resource = (AutoConfResource)iterator.next();
                    Dictionary properties = resource.getProperties();
                    String bundleLocation = resource.getBundleLocation();
                    Configuration configuration = null;
                    if (resource.isFactoryConfig()) {
                        i2 = existingResources.iterator();
                        while (i2.hasNext()) {
                            existingResource = (AutoConfResource)i2.next();
                            if (!resource.equalsTargetConfiguration(existingResource)) continue;
                            configuration = this.m_configAdmin.getConfiguration(existingResource.getGeneratedPid(), bundleLocation);
                            existingResources.remove(existingResource);
                            break;
                        }
                        if (configuration == null) {
                            configuration = this.m_configAdmin.createFactoryConfiguration(resource.getFactoryPid(), bundleLocation);
                        }
                        resource.setGeneratedPid(configuration.getPid());
                    } else {
                        i2 = existingResources.iterator();
                        while (i2.hasNext()) {
                            existingResource = (AutoConfResource)i2.next();
                            if (!resource.getPid().equals(existingResource.getPid())) continue;
                            existingResources.remove(existingResource);
                            break;
                        }
                        if (!bundleLocation.equals((configuration = this.m_configAdmin.getConfiguration(resource.getPid(), bundleLocation)).getBundleLocation())) {
                            throw new ResourceProcessorException(1, "Existing configuration was not unbound and not bound to the specified bundlelocation");
                        }
                    }
                    if (resource.isMerge() && (existingProperties = configuration.getProperties()) != null) {
                        Enumeration keys = existingProperties.keys();
                        while (keys.hasMoreElements()) {
                            Object key = keys.nextElement();
                            properties.put(key, existingProperties.get(key));
                        }
                    }
                    configuration.update(properties);
                }
                Iterator i3 = existingResources.iterator();
                while (i3.hasNext()) {
                    AutoConfResource existingResource = (AutoConfResource)i3.next();
                    Configuration configuration = null;
                    configuration = existingResource.isFactoryConfig() ? this.m_configAdmin.getConfiguration(existingResource.getGeneratedPid(), existingResource.getBundleLocation()) : this.m_configAdmin.getConfiguration(existingResource.getPid(), existingResource.getBundleLocation());
                    configuration.delete();
                }
                this.m_persistencyManager.store(name, resources);
            }
        }
        catch (IOException ioe) {
            this.m_toBeInstalled.clear();
            throw new ResourceProcessorException(1, "Unable to prepare for commit for resource", ioe);
        }
    }

    public synchronized void commit() {
        this.m_toBeInstalled.clear();
        this.m_toBeDeleted.clear();
        this.m_session = null;
    }

    public void rollback() {
        Set keys = this.m_toBeInstalled.keySet();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            List configs = (List)this.m_toBeInstalled.get(i.next());
            Iterator j = configs.iterator();
            if (!j.hasNext()) continue;
            AutoConfResource resource = (AutoConfResource)j.next();
            String name = resource.getName();
            try {
                this.dropped(name);
            }
            catch (ResourceProcessorException e) {
                this.m_log.log(1, "Unable to roll back resource '" + name + "', reason: " + e.getMessage() + ", caused by: " + e.getCause().getMessage());
            }
        }
        this.m_toBeInstalled.clear();
        this.m_session = null;
    }

    public void cancel() {
        this.rollback();
        this.m_session = null;
    }

    private Dictionary getProperties(Designate designate, ObjectClassDefinition ocd) throws ResourceProcessorException {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        AttributeDefinition[] attributeDefs = ocd.getAttributeDefinitions(-1);
        List attributes = designate.getObject().getAttributes();
        Iterator i = attributes.iterator();
        while (i.hasNext()) {
            Attribute attribute = (Attribute)i.next();
            String adRef = attribute.getAdRef();
            boolean found = false;
            for (int j = 0; j < attributeDefs.length; ++j) {
                AttributeDefinition ad = attributeDefs[j];
                if (!adRef.equals(ad.getID())) continue;
                Object value = this.getValue(attribute, ad);
                if (value == null) {
                    if (designate.isOptional()) {
                        properties = null;
                        break;
                    }
                    throw new ResourceProcessorException(463, "Could not match attribute to it's definition: adref=" + adRef);
                }
                ((Dictionary)properties).put(adRef, value);
                found = true;
                break;
            }
            if (found) continue;
            if (designate.isOptional()) {
                properties = null;
                break;
            }
            throw new ResourceProcessorException(463, "Could not find attribute definition: adref=" + adRef);
        }
        return properties;
    }

    private ObjectClassDefinition getMetaTypeOCD(MetaData data, Designate designate) throws ResourceProcessorException {
        MetaTypeInformation mti;
        ObjectClassDefinition ocd = null;
        String ocdRef = designate.getObject().getOcdRef();
        Bundle bundle = this.getBundle(designate.getBundleLocation(), this.isFactoryConfig(designate));
        if (bundle != null && (mti = this.m_metaService.getMetaTypeInformation(bundle)) != null) {
            String pid;
            pid = this.isFactoryConfig(designate) ? (pid = designate.getFactoryPid()) : designate.getPid();
            try {
                ObjectClassDefinition tempOcd = mti.getObjectClassDefinition(pid, null);
                if (ocdRef.equals(tempOcd.getID())) {
                    ocd = tempOcd;
                }
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }
        return ocd;
    }

    private boolean isFactoryConfig(Designate designate) {
        String factoryPid = designate.getFactoryPid();
        return factoryPid != null || !"".equals(factoryPid);
    }

    private Bundle getBundle(String bundleLocation, boolean isFactory) throws ResourceProcessorException {
        Bundle bundle;
        block2: {
            block1: {
                bundle = null;
                if (isFactory) break block1;
                if (!bundleLocation.startsWith(LOCATION_PREFIX)) break block2;
                bundle = this.m_session.getSourceDeploymentPackage().getBundle(bundleLocation.substring(LOCATION_PREFIX.length()));
                break block2;
            }
            Bundle[] bundles = this.m_bc.getBundles();
            for (int i = 0; i < bundles.length; ++i) {
                String location = bundles[i].getLocation();
                if (!bundleLocation.equals(location)) continue;
                bundle = bundles[i];
                break;
            }
        }
        return bundle;
    }

    private Object getValue(Attribute attribute, AttributeDefinition ad) {
        if (attribute == null || ad == null || !attribute.getAdRef().equals(ad.getID())) {
            return null;
        }
        String[] content = attribute.getContent();
        int type = ad.getType();
        Boolean[] typedContent = null;
        try {
            block13: for (int i = 0; i < content.length; ++i) {
                String value = content[i];
                switch (type) {
                    case 11: {
                        typedContent = typedContent == null ? new Boolean[content.length] : typedContent;
                        typedContent[i] = Boolean.valueOf(value);
                        continue block13;
                    }
                    case 6: {
                        typedContent = typedContent == null ? new Byte[content.length] : typedContent;
                        typedContent[i] = Byte.valueOf(value);
                        continue block13;
                    }
                    case 5: {
                        typedContent = typedContent == null ? new Character[content.length] : typedContent;
                        char[] charArray = value.toCharArray();
                        if (charArray.length == 1) {
                            typedContent[i] = new Character(charArray[0]);
                            continue block13;
                        }
                        return null;
                    }
                    case 7: {
                        typedContent = typedContent == null ? new Double[content.length] : typedContent;
                        typedContent[i] = Double.valueOf(value);
                        continue block13;
                    }
                    case 8: {
                        typedContent = typedContent == null ? new Float[content.length] : typedContent;
                        typedContent[i] = Float.valueOf(value);
                        continue block13;
                    }
                    case 3: {
                        typedContent = typedContent == null ? new Integer[content.length] : typedContent;
                        typedContent[i] = Integer.valueOf(value);
                        continue block13;
                    }
                    case 2: {
                        typedContent = typedContent == null ? new Long[content.length] : typedContent;
                        typedContent[i] = Long.valueOf(value);
                        continue block13;
                    }
                    case 4: {
                        typedContent = typedContent == null ? new Short[content.length] : typedContent;
                        typedContent[i] = Short.valueOf(value);
                        continue block13;
                    }
                    case 1: {
                        typedContent = typedContent == null ? new String[content.length] : typedContent;
                        typedContent[i] = value;
                        continue block13;
                    }
                    default: {
                        return null;
                    }
                }
            }
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        int cardinality = ad.getCardinality();
        Object result = null;
        if (cardinality == 0) {
            result = typedContent.length == 1 ? typedContent[0] : null;
        } else if (cardinality == Integer.MIN_VALUE) {
            result = new Vector<Boolean>(Arrays.asList(typedContent));
        } else if (cardinality == Integer.MAX_VALUE) {
            result = typedContent;
        } else if (cardinality < 0) {
            result = typedContent.length == cardinality ? new Vector<Boolean>(Arrays.asList(typedContent)) : null;
        } else if (cardinality > 0) {
            result = typedContent.length == cardinality ? typedContent : null;
        }
        return result;
    }
}

