/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import org.apache.camel.v1.buildstatus.Artifacts;
import org.apache.camel.v1.buildstatus.Conditions;
import org.apache.camel.v1.buildstatus.Failure;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"artifacts", "baseImage", "conditions", "digest", "duration", "error", "failure", "image", "observedGeneration", "phase", "startedAt"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class BuildStatus
implements KubernetesResource {
    @JsonProperty(value="artifacts")
    @JsonPropertyDescription(value="a list of artifacts contained in the build")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Artifacts> artifacts;
    @JsonProperty(value="baseImage")
    @JsonPropertyDescription(value="the base image used for this build")
    @JsonSetter(nulls=Nulls.SKIP)
    private String baseImage;
    @JsonProperty(value="conditions")
    @JsonPropertyDescription(value="a list of conditions occurred during the build")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Conditions> conditions;
    @JsonProperty(value="digest")
    @JsonPropertyDescription(value="the digest from image")
    @JsonSetter(nulls=Nulls.SKIP)
    private String digest;
    @JsonProperty(value="duration")
    @JsonPropertyDescription(value="how long it took for the build Change to Duration / ISO 8601 when CRD uses OpenAPI spec v3 https://github.com/OAI/OpenAPI-Specification/issues/845")
    @JsonSetter(nulls=Nulls.SKIP)
    private String duration;
    @JsonProperty(value="error")
    @JsonPropertyDescription(value="the error description (if any)")
    @JsonSetter(nulls=Nulls.SKIP)
    private String error;
    @JsonProperty(value="failure")
    @JsonPropertyDescription(value="the reason of the failure (if any)")
    @JsonSetter(nulls=Nulls.SKIP)
    private Failure failure;
    @JsonProperty(value="image")
    @JsonPropertyDescription(value="the image name built")
    @JsonSetter(nulls=Nulls.SKIP)
    private String image;
    @JsonProperty(value="observedGeneration")
    @JsonPropertyDescription(value="ObservedGeneration is the most recent generation observed for this Build.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long observedGeneration;
    @JsonProperty(value="phase")
    @JsonPropertyDescription(value="describes the phase")
    @JsonSetter(nulls=Nulls.SKIP)
    private String phase;
    @JsonProperty(value="startedAt")
    @JsonPropertyDescription(value="the time when it started")
    @JsonSetter(nulls=Nulls.SKIP)
    private String startedAt;

    public List<Artifacts> getArtifacts() {
        return this.artifacts;
    }

    public void setArtifacts(List<Artifacts> artifacts) {
        this.artifacts = artifacts;
    }

    public String getBaseImage() {
        return this.baseImage;
    }

    public void setBaseImage(String baseImage) {
        this.baseImage = baseImage;
    }

    public List<Conditions> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<Conditions> conditions) {
        this.conditions = conditions;
    }

    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public Failure getFailure() {
        return this.failure;
    }

    public void setFailure(Failure failure) {
        this.failure = failure;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public String getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(String startedAt) {
        this.startedAt = startedAt;
    }
}

