/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import org.apache.camel.v1.integrationkitstatus.Artifacts;
import org.apache.camel.v1.integrationkitstatus.Conditions;
import org.apache.camel.v1.integrationkitstatus.Failure;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"artifacts", "baseImage", "conditions", "digest", "failure", "image", "observedGeneration", "phase", "platform", "runtimeProvider", "runtimeVersion", "version"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class IntegrationKitStatus
implements KubernetesResource {
    @JsonProperty(value="artifacts")
    @JsonPropertyDescription(value="list of artifacts used by the kit")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Artifacts> artifacts;
    @JsonProperty(value="baseImage")
    @JsonPropertyDescription(value="base image used by the kit")
    @JsonSetter(nulls=Nulls.SKIP)
    private String baseImage;
    @JsonProperty(value="conditions")
    @JsonPropertyDescription(value="a list of conditions which happened for the events related the kit")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Conditions> conditions;
    @JsonProperty(value="digest")
    @JsonPropertyDescription(value="actual image digest of the kit")
    @JsonSetter(nulls=Nulls.SKIP)
    private String digest;
    @JsonProperty(value="failure")
    @JsonPropertyDescription(value="failure reason (if any)")
    @JsonSetter(nulls=Nulls.SKIP)
    private Failure failure;
    @JsonProperty(value="image")
    @JsonPropertyDescription(value="actual image name of the kit")
    @JsonSetter(nulls=Nulls.SKIP)
    private String image;
    @JsonProperty(value="observedGeneration")
    @JsonPropertyDescription(value="ObservedGeneration is the most recent generation observed for this IntegrationKit.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long observedGeneration;
    @JsonProperty(value="phase")
    @JsonPropertyDescription(value="phase of the kit")
    @JsonSetter(nulls=Nulls.SKIP)
    private String phase;
    @JsonProperty(value="platform")
    @JsonPropertyDescription(value="the platform for which this kit was configured")
    @JsonSetter(nulls=Nulls.SKIP)
    private String platform;
    @JsonProperty(value="runtimeProvider")
    @JsonPropertyDescription(value="the runtime provider for which this kit was configured")
    @JsonSetter(nulls=Nulls.SKIP)
    private String runtimeProvider;
    @JsonProperty(value="runtimeVersion")
    @JsonPropertyDescription(value="the runtime version for which this kit was configured")
    @JsonSetter(nulls=Nulls.SKIP)
    private String runtimeVersion;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="the Camel K operator version for which this kit was configured")
    @JsonSetter(nulls=Nulls.SKIP)
    private String version;

    public List<Artifacts> getArtifacts() {
        return this.artifacts;
    }

    public void setArtifacts(List<Artifacts> artifacts) {
        this.artifacts = artifacts;
    }

    public String getBaseImage() {
        return this.baseImage;
    }

    public void setBaseImage(String baseImage) {
        this.baseImage = baseImage;
    }

    public List<Conditions> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<Conditions> conditions) {
        this.conditions = conditions;
    }

    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public Failure getFailure() {
        return this.failure;
    }

    public void setFailure(Failure failure) {
        this.failure = failure;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getRuntimeProvider() {
        return this.runtimeProvider;
    }

    public void setRuntimeProvider(String runtimeProvider) {
        this.runtimeProvider = runtimeProvider;
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public void setRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

