/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationkitspec;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import org.apache.camel.v1.integrationkitspec.traits.Addons;
import org.apache.camel.v1.integrationkitspec.traits.Builder;
import org.apache.camel.v1.integrationkitspec.traits.Camel;
import org.apache.camel.v1.integrationkitspec.traits.Quarkus;
import org.apache.camel.v1.integrationkitspec.traits.Registry;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"addons", "builder", "camel", "quarkus", "registry"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Traits
implements KubernetesResource {
    @JsonProperty(value="addons")
    @JsonPropertyDescription(value="The collection of addon trait configurations")
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, Addons> addons;
    @JsonProperty(value="builder")
    @JsonPropertyDescription(value="The builder trait is internally used to determine the best strategy to build and configure IntegrationKits.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Builder builder;
    @JsonProperty(value="camel")
    @JsonPropertyDescription(value="The Camel trait sets up Camel configuration.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Camel camel;
    @JsonProperty(value="quarkus")
    @JsonPropertyDescription(value="The Quarkus trait configures the Quarkus runtime. It's enabled by default. NOTE: Compiling to a native executable, i.e. when using `package-type=native`, is only supported for kamelets, as well as YAML and XML integrations. It also requires at least 4GiB of memory, so the Pod running the native build, that is either the operator Pod, or the build Pod (depending on the build strategy configured for the platform), must have enough memory available.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Quarkus quarkus;
    @JsonProperty(value="registry")
    @JsonPropertyDescription(value="The Registry trait sets up Maven to use the Image registry as a Maven repository.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Registry registry;

    public Map<String, Addons> getAddons() {
        return this.addons;
    }

    public void setAddons(Map<String, Addons> addons) {
        this.addons = addons;
    }

    public Builder getBuilder() {
        return this.builder;
    }

    public void setBuilder(Builder builder) {
        this.builder = builder;
    }

    public Camel getCamel() {
        return this.camel;
    }

    public void setCamel(Camel camel) {
        this.camel = camel;
    }

    public Quarkus getQuarkus() {
        return this.quarkus;
    }

    public void setQuarkus(Quarkus quarkus) {
        this.quarkus = quarkus;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }
}

