/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationplatformspec.traits;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import org.apache.camel.v1.integrationplatformspec.traits.knativeservice.Configuration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"auto", "autoscalingMetric", "autoscalingTarget", "class", "configuration", "enabled", "maxScale", "minScale", "rolloutDuration", "visibility"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class KnativeService
implements KubernetesResource {
    @JsonProperty(value="auto")
    @JsonPropertyDescription(value="Automatically deploy the integration as Knative service when all conditions hold: \n * Integration is using the Knative profile * All routes are either starting from an HTTP based consumer or a passive consumer (e.g. `direct` is a passive consumer)")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean auto;
    @JsonProperty(value="autoscalingMetric")
    @JsonPropertyDescription(value="Configures the Knative autoscaling metric property (e.g. to set `concurrency` based or `cpu` based autoscaling). \n Refer to the Knative documentation for more information.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String autoscalingMetric;
    @JsonProperty(value="autoscalingTarget")
    @JsonPropertyDescription(value="Sets the allowed concurrency level or CPU percentage (depending on the autoscaling metric) for each Pod. \n Refer to the Knative documentation for more information.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long autoscalingTarget;
    @JsonProperty(value="class")
    @JsonPropertyDescription(value="Configures the Knative autoscaling class property (e.g. to set `hpa.autoscaling.knative.dev` or `kpa.autoscaling.knative.dev` autoscaling). \n Refer to the Knative documentation for more information.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Class _class;
    @JsonProperty(value="configuration")
    @JsonPropertyDescription(value="Legacy trait configuration parameters. Deprecated: for backward compatibility.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Configuration configuration;
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Can be used to enable or disable a trait. All traits share this common property.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean enabled;
    @JsonProperty(value="maxScale")
    @JsonPropertyDescription(value="An upper bound for the number of Pods that can be running in parallel for the integration. Knative has its own cap value that depends on the installation. \n Refer to the Knative documentation for more information.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long maxScale;
    @JsonProperty(value="minScale")
    @JsonPropertyDescription(value="The minimum number of Pods that should be running at any time for the integration. It's **zero** by default, meaning that the integration is scaled down to zero when not used for a configured amount of time. \n Refer to the Knative documentation for more information.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long minScale;
    @JsonProperty(value="rolloutDuration")
    @JsonPropertyDescription(value="Enables to gradually shift traffic to the latest Revision and sets the rollout duration. It's disabled by default and must be expressed as a Golang `time.Duration` string representation, rounded to a second precision.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String rolloutDuration;
    @JsonProperty(value="visibility")
    @JsonPropertyDescription(value="Setting `cluster-local`, Knative service becomes a private service. Specifically, this option applies the `networking.knative.dev/visibility` label to Knative service. \n Refer to the Knative documentation for more information.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Visibility visibility;

    public Boolean getAuto() {
        return this.auto;
    }

    public void setAuto(Boolean auto) {
        this.auto = auto;
    }

    public String getAutoscalingMetric() {
        return this.autoscalingMetric;
    }

    public void setAutoscalingMetric(String autoscalingMetric) {
        this.autoscalingMetric = autoscalingMetric;
    }

    public Long getAutoscalingTarget() {
        return this.autoscalingTarget;
    }

    public void setAutoscalingTarget(Long autoscalingTarget) {
        this.autoscalingTarget = autoscalingTarget;
    }

    public Class get_class() {
        return this._class;
    }

    public void set_class(Class _class) {
        this._class = _class;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Long getMaxScale() {
        return this.maxScale;
    }

    public void setMaxScale(Long maxScale) {
        this.maxScale = maxScale;
    }

    public Long getMinScale() {
        return this.minScale;
    }

    public void setMinScale(Long minScale) {
        this.minScale = minScale;
    }

    public String getRolloutDuration() {
        return this.rolloutDuration;
    }

    public void setRolloutDuration(String rolloutDuration) {
        this.rolloutDuration = rolloutDuration;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public static enum Visibility {
        CLUSTERLOCAL("cluster-local");

        String value;

        private Visibility(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }

    public static enum Class {
        KPA_AUTOSCALING_KNATIVE_DEV("kpa.autoscaling.knative.dev"),
        HPA_AUTOSCALING_KNATIVE_DEV("hpa.autoscaling.knative.dev");

        String value;

        private Class(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }
}

