/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationspec.template.spec.volumes;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.generator.annotation.Required;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import org.apache.camel.v1.integrationspec.template.spec.volumes.iscsi.SecretRef;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"chapAuthDiscovery", "chapAuthSession", "fsType", "initiatorName", "iqn", "iscsiInterface", "lun", "portals", "readOnly", "secretRef", "targetPortal"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Iscsi
implements KubernetesResource {
    @JsonProperty(value="chapAuthDiscovery")
    @JsonPropertyDescription(value="chapAuthDiscovery defines whether support iSCSI Discovery CHAP authentication")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean chapAuthDiscovery;
    @JsonProperty(value="chapAuthSession")
    @JsonPropertyDescription(value="chapAuthSession defines whether support iSCSI Session CHAP authentication")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean chapAuthSession;
    @JsonProperty(value="fsType")
    @JsonPropertyDescription(value="fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi TODO: how do we prevent errors in the filesystem from compromising the machine")
    @JsonSetter(nulls=Nulls.SKIP)
    private String fsType;
    @JsonProperty(value="initiatorName")
    @JsonPropertyDescription(value="initiatorName is the custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface <target portal>:<volume name> will be created for the connection.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String initiatorName;
    @JsonProperty(value="iqn")
    @Required
    @JsonPropertyDescription(value="iqn is the target iSCSI Qualified Name.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String iqn;
    @JsonProperty(value="iscsiInterface")
    @JsonPropertyDescription(value="iscsiInterface is the interface Name that uses an iSCSI transport. Defaults to 'default' (tcp).")
    @JsonSetter(nulls=Nulls.SKIP)
    private String iscsiInterface;
    @JsonProperty(value="lun")
    @Required
    @JsonPropertyDescription(value="lun represents iSCSI Target Lun number.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Integer lun;
    @JsonProperty(value="portals")
    @JsonPropertyDescription(value="portals is the iSCSI Target Portal List. The portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> portals;
    @JsonProperty(value="readOnly")
    @JsonPropertyDescription(value="readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean readOnly;
    @JsonProperty(value="secretRef")
    @JsonPropertyDescription(value="secretRef is the CHAP Secret for iSCSI target and initiator authentication")
    @JsonSetter(nulls=Nulls.SKIP)
    private SecretRef secretRef;
    @JsonProperty(value="targetPortal")
    @Required
    @JsonPropertyDescription(value="targetPortal is iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).")
    @JsonSetter(nulls=Nulls.SKIP)
    private String targetPortal;

    public Boolean getChapAuthDiscovery() {
        return this.chapAuthDiscovery;
    }

    public void setChapAuthDiscovery(Boolean chapAuthDiscovery) {
        this.chapAuthDiscovery = chapAuthDiscovery;
    }

    public Boolean getChapAuthSession() {
        return this.chapAuthSession;
    }

    public void setChapAuthSession(Boolean chapAuthSession) {
        this.chapAuthSession = chapAuthSession;
    }

    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public String getInitiatorName() {
        return this.initiatorName;
    }

    public void setInitiatorName(String initiatorName) {
        this.initiatorName = initiatorName;
    }

    public String getIqn() {
        return this.iqn;
    }

    public void setIqn(String iqn) {
        this.iqn = iqn;
    }

    public String getIscsiInterface() {
        return this.iscsiInterface;
    }

    public void setIscsiInterface(String iscsiInterface) {
        this.iscsiInterface = iscsiInterface;
    }

    public Integer getLun() {
        return this.lun;
    }

    public void setLun(Integer lun) {
        this.lun = lun;
    }

    public List<String> getPortals() {
        return this.portals;
    }

    public void setPortals(List<String> portals) {
        this.portals = portals;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public SecretRef getSecretRef() {
        return this.secretRef;
    }

    public void setSecretRef(SecretRef secretRef) {
        this.secretRef = secretRef;
    }

    public String getTargetPortal() {
        return this.targetPortal;
    }

    public void setTargetPortal(String targetPortal) {
        this.targetPortal = targetPortal;
    }
}

