/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationspec.traits;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import org.apache.camel.v1.integrationspec.traits.mount.Configuration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"configs", "configuration", "enabled", "resources", "volumes"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Mount
implements KubernetesResource {
    @JsonProperty(value="configs")
    @JsonPropertyDescription(value="A list of configuration pointing to configmap/secret. The configuration are expected to be UTF-8 resources as they are processed by runtime Camel Context and tried to be parsed as property files. They are also made available on the classpath in order to ease their usage directly from the Route. Syntax: [configmap|secret]:name[/key], where name represents the resource name and key optionally represents the resource key to be filtered")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> configs;
    @JsonProperty(value="configuration")
    @JsonPropertyDescription(value="Legacy trait configuration parameters. Deprecated: for backward compatibility.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Configuration configuration;
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Can be used to enable or disable a trait. All traits share this common property.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean enabled;
    @JsonProperty(value="resources")
    @JsonPropertyDescription(value="A list of resources (text or binary content) pointing to configmap/secret. The resources are expected to be any resource type (text or binary content). The destination path can be either a default location or any path specified by the user. Syntax: [configmap|secret]:name[/key][@path], where name represents the resource name, key optionally represents the resource key to be filtered and path represents the destination path")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> resources;
    @JsonProperty(value="volumes")
    @JsonPropertyDescription(value="A list of Persistent Volume Claims to be mounted. Syntax: [pvcname:/container/path]")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> volumes;

    public List<String> getConfigs() {
        return this.configs;
    }

    public void setConfigs(List<String> configs) {
        this.configs = configs;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public List<String> getResources() {
        return this.resources;
    }

    public void setResources(List<String> resources) {
        this.resources = resources;
    }

    public List<String> getVolumes() {
        return this.volumes;
    }

    public void setVolumes(List<String> volumes) {
        this.volumes = volumes;
    }
}

