/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationspec.traits;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import org.apache.camel.v1.integrationspec.traits.route.Configuration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"configuration", "enabled", "host", "tlsCACertificate", "tlsCACertificateSecret", "tlsCertificate", "tlsCertificateSecret", "tlsDestinationCACertificate", "tlsDestinationCACertificateSecret", "tlsInsecureEdgeTerminationPolicy", "tlsKey", "tlsKeySecret", "tlsTermination"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Route
implements KubernetesResource {
    @JsonProperty(value="configuration")
    @JsonPropertyDescription(value="Legacy trait configuration parameters. Deprecated: for backward compatibility.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Configuration configuration;
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Can be used to enable or disable a trait. All traits share this common property.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean enabled;
    @JsonProperty(value="host")
    @JsonPropertyDescription(value="To configure the host exposed by the route.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String host;
    @JsonProperty(value="tlsCACertificate")
    @JsonPropertyDescription(value="The TLS CA certificate contents. \n Refer to the OpenShift route documentation for additional information.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String tlsCACertificate;
    @JsonProperty(value="tlsCACertificateSecret")
    @JsonPropertyDescription(value="The secret name and key reference to the TLS CA certificate. The format is \"secret-name[/key-name]\", the value represents the secret name, if there is only one key in the secret it will be read, otherwise you can set a key name separated with a \"/\". \n Refer to the OpenShift route documentation for additional information.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String tlsCACertificateSecret;
    @JsonProperty(value="tlsCertificate")
    @JsonPropertyDescription(value="The TLS certificate contents. \n Refer to the OpenShift route documentation for additional information.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String tlsCertificate;
    @JsonProperty(value="tlsCertificateSecret")
    @JsonPropertyDescription(value="The secret name and key reference to the TLS certificate. The format is \"secret-name[/key-name]\", the value represents the secret name, if there is only one key in the secret it will be read, otherwise you can set a key name separated with a \"/\". \n Refer to the OpenShift route documentation for additional information.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String tlsCertificateSecret;
    @JsonProperty(value="tlsDestinationCACertificate")
    @JsonPropertyDescription(value="The destination CA certificate provides the contents of the ca certificate of the final destination.  When using reencrypt termination this file should be provided in order to have routers use it for health checks on the secure connection. If this field is not specified, the router may provide its own destination CA and perform hostname validation using the short service name (service.namespace.svc), which allows infrastructure generated certificates to automatically verify. \n Refer to the OpenShift route documentation for additional information.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String tlsDestinationCACertificate;
    @JsonProperty(value="tlsDestinationCACertificateSecret")
    @JsonPropertyDescription(value="The secret name and key reference to the destination CA certificate. The format is \"secret-name[/key-name]\", the value represents the secret name, if there is only one key in the secret it will be read, otherwise you can set a key name separated with a \"/\". \n Refer to the OpenShift route documentation for additional information.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String tlsDestinationCACertificateSecret;
    @JsonProperty(value="tlsInsecureEdgeTerminationPolicy")
    @JsonPropertyDescription(value="To configure how to deal with insecure traffic, e.g. `Allow`, `Disable` or `Redirect` traffic. \n Refer to the OpenShift route documentation for additional information.")
    @JsonSetter(nulls=Nulls.SKIP)
    private TlsInsecureEdgeTerminationPolicy tlsInsecureEdgeTerminationPolicy;
    @JsonProperty(value="tlsKey")
    @JsonPropertyDescription(value="The TLS certificate key contents. \n Refer to the OpenShift route documentation for additional information.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String tlsKey;
    @JsonProperty(value="tlsKeySecret")
    @JsonPropertyDescription(value="The secret name and key reference to the TLS certificate key. The format is \"secret-name[/key-name]\", the value represents the secret name, if there is only one key in the secret it will be read, otherwise you can set a key name separated with a \"/\". \n Refer to the OpenShift route documentation for additional information.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String tlsKeySecret;
    @JsonProperty(value="tlsTermination")
    @JsonPropertyDescription(value="The TLS termination type, like `edge`, `passthrough` or `reencrypt`. \n Refer to the OpenShift route documentation for additional information.")
    @JsonSetter(nulls=Nulls.SKIP)
    private TlsTermination tlsTermination;

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getTlsCACertificate() {
        return this.tlsCACertificate;
    }

    public void setTlsCACertificate(String tlsCACertificate) {
        this.tlsCACertificate = tlsCACertificate;
    }

    public String getTlsCACertificateSecret() {
        return this.tlsCACertificateSecret;
    }

    public void setTlsCACertificateSecret(String tlsCACertificateSecret) {
        this.tlsCACertificateSecret = tlsCACertificateSecret;
    }

    public String getTlsCertificate() {
        return this.tlsCertificate;
    }

    public void setTlsCertificate(String tlsCertificate) {
        this.tlsCertificate = tlsCertificate;
    }

    public String getTlsCertificateSecret() {
        return this.tlsCertificateSecret;
    }

    public void setTlsCertificateSecret(String tlsCertificateSecret) {
        this.tlsCertificateSecret = tlsCertificateSecret;
    }

    public String getTlsDestinationCACertificate() {
        return this.tlsDestinationCACertificate;
    }

    public void setTlsDestinationCACertificate(String tlsDestinationCACertificate) {
        this.tlsDestinationCACertificate = tlsDestinationCACertificate;
    }

    public String getTlsDestinationCACertificateSecret() {
        return this.tlsDestinationCACertificateSecret;
    }

    public void setTlsDestinationCACertificateSecret(String tlsDestinationCACertificateSecret) {
        this.tlsDestinationCACertificateSecret = tlsDestinationCACertificateSecret;
    }

    public TlsInsecureEdgeTerminationPolicy getTlsInsecureEdgeTerminationPolicy() {
        return this.tlsInsecureEdgeTerminationPolicy;
    }

    public void setTlsInsecureEdgeTerminationPolicy(TlsInsecureEdgeTerminationPolicy tlsInsecureEdgeTerminationPolicy) {
        this.tlsInsecureEdgeTerminationPolicy = tlsInsecureEdgeTerminationPolicy;
    }

    public String getTlsKey() {
        return this.tlsKey;
    }

    public void setTlsKey(String tlsKey) {
        this.tlsKey = tlsKey;
    }

    public String getTlsKeySecret() {
        return this.tlsKeySecret;
    }

    public void setTlsKeySecret(String tlsKeySecret) {
        this.tlsKeySecret = tlsKeySecret;
    }

    public TlsTermination getTlsTermination() {
        return this.tlsTermination;
    }

    public void setTlsTermination(TlsTermination tlsTermination) {
        this.tlsTermination = tlsTermination;
    }

    public static enum TlsTermination {
        EDGE("edge"),
        REENCRYPT("reencrypt"),
        PASSTHROUGH("passthrough");

        String value;

        private TlsTermination(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }

    public static enum TlsInsecureEdgeTerminationPolicy {
        NONE("None"),
        ALLOW("Allow"),
        REDIRECT("Redirect");

        String value;

        private TlsInsecureEdgeTerminationPolicy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }
}

