/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/apache/camel-k/pkg/apis/camel/v1"
)

// RuntimeSpecApplyConfiguration represents an declarative configuration of the RuntimeSpec type for use
// with apply.
type RuntimeSpecApplyConfiguration struct {
	Version          *string                                 `json:"version,omitempty"`
	Provider         *v1.RuntimeProvider                     `json:"provider,omitempty"`
	ApplicationClass *string                                 `json:"applicationClass,omitempty"`
	Dependencies     []MavenArtifactApplyConfiguration       `json:"dependencies,omitempty"`
	Metadata         map[string]string                       `json:"metadata,omitempty"`
	Capabilities     map[string]CapabilityApplyConfiguration `json:"capabilities,omitempty"`
}

// RuntimeSpecApplyConfiguration constructs an declarative configuration of the RuntimeSpec type for use with
// apply.
func RuntimeSpec() *RuntimeSpecApplyConfiguration {
	return &RuntimeSpecApplyConfiguration{}
}

// WithVersion sets the Version field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Version field is set to the value of the last call.
func (b *RuntimeSpecApplyConfiguration) WithVersion(value string) *RuntimeSpecApplyConfiguration {
	b.Version = &value
	return b
}

// WithProvider sets the Provider field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Provider field is set to the value of the last call.
func (b *RuntimeSpecApplyConfiguration) WithProvider(value v1.RuntimeProvider) *RuntimeSpecApplyConfiguration {
	b.Provider = &value
	return b
}

// WithApplicationClass sets the ApplicationClass field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ApplicationClass field is set to the value of the last call.
func (b *RuntimeSpecApplyConfiguration) WithApplicationClass(value string) *RuntimeSpecApplyConfiguration {
	b.ApplicationClass = &value
	return b
}

// WithDependencies adds the given value to the Dependencies field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Dependencies field.
func (b *RuntimeSpecApplyConfiguration) WithDependencies(values ...*MavenArtifactApplyConfiguration) *RuntimeSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithDependencies")
		}
		b.Dependencies = append(b.Dependencies, *values[i])
	}
	return b
}

// WithMetadata puts the entries into the Metadata field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Metadata field,
// overwriting an existing map entries in Metadata field with the same key.
func (b *RuntimeSpecApplyConfiguration) WithMetadata(entries map[string]string) *RuntimeSpecApplyConfiguration {
	if b.Metadata == nil && len(entries) > 0 {
		b.Metadata = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.Metadata[k] = v
	}
	return b
}

// WithCapabilities puts the entries into the Capabilities field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Capabilities field,
// overwriting an existing map entries in Capabilities field with the same key.
func (b *RuntimeSpecApplyConfiguration) WithCapabilities(entries map[string]CapabilityApplyConfiguration) *RuntimeSpecApplyConfiguration {
	if b.Capabilities == nil && len(entries) > 0 {
		b.Capabilities = make(map[string]CapabilityApplyConfiguration, len(entries))
	}
	for k, v := range entries {
		b.Capabilities[k] = v
	}
	return b
}
