/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging;

import java.io.File;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingTest;
import org.apache.commons.imaging.ImagingTestConstants;
import org.apache.commons.io.FilenameUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class ImagingGuessFormatTest
extends ImagingTest {
    public static final String BMP_IMAGE_FILE = "bmp\\1\\Oregon Scientific DS6639 - DSC_0307 - small.bmp";
    public static final String PNG_IMAGE_FILE = "png\\1\\Oregon Scientific DS6639 - DSC_0307 - small.png";
    public static final String GIF_IMAGE_FILE = "gif\\single\\1\\Oregon Scientific DS6639 - DSC_0307 - small.gif";
    public static final String ICNS_IMAGE_FILE = "icns\\1\\poedit48x48.icns";
    public static final String ICO_IMAGE_FILE = "ico\\1\\Oregon Scientific DS6639 - DSC_0307 - small.ico";
    public static final String TIFF_IMAGE_FILE = "tiff\\1\\Oregon Scientific DS6639 - DSC_0307 - small.tif";
    public static final String JPEG_IMAGE_FILE = "jpg\\1\\Oregon Scientific DS6639 - DSC_0307 - small.jpg";
    public static final String PSD_IMAGE_FILE = "psd\\1\\Oregon Scientific DS6639 - DSC_0307 - small.psd";
    public static final String PBM_IMAGE_FILE = "pbm\\1\\Oregon Scientific DS6639 - DSC_0307 - small.pbm";
    public static final String PGM_IMAGE_FILE = "pbm\\1\\Oregon Scientific DS6639 - DSC_0307 - small.pgm";
    public static final String PPM_IMAGE_FILE = "pbm\\1\\Oregon Scientific DS6639 - DSC_0307 - small.ppm";
    public static final String TGA_IMAGE_FILE = "tga\\1\\Oregon Scientific DS6639 - DSC_0307 - small.tga";
    public static final String UNKNOWN_IMAGE_FILE = "info.txt";

    public static Stream<Object[]> data() {
        return Arrays.asList({ImageFormats.PNG, PNG_IMAGE_FILE}, {ImageFormats.GIF, GIF_IMAGE_FILE}, {ImageFormats.ICNS, ICNS_IMAGE_FILE}, {ImageFormats.TIFF, TIFF_IMAGE_FILE}, {ImageFormats.JPEG, JPEG_IMAGE_FILE}, {ImageFormats.BMP, BMP_IMAGE_FILE}, {ImageFormats.PSD, PSD_IMAGE_FILE}, {ImageFormats.PBM, PBM_IMAGE_FILE}, {ImageFormats.PGM, PGM_IMAGE_FILE}, {ImageFormats.PPM, PPM_IMAGE_FILE}, {ImageFormats.UNKNOWN, UNKNOWN_IMAGE_FILE}).stream();
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testGuessFormat(ImageFormats expectedFormat, String pathToFile) throws Exception {
        String imagePath = FilenameUtils.separatorsToSystem((String)pathToFile);
        File imageFile = new File(ImagingTestConstants.TEST_IMAGE_FOLDER, imagePath);
        ImageFormat guessedFormat = Imaging.guessFormat((File)imageFile);
        Assertions.assertEquals((Object)expectedFormat, (Object)guessedFormat);
    }
}

