/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging;

import java.util.stream.Stream;
import org.apache.commons.imaging.ImageWriteException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class TestImageWriteException {
    public static Stream<Object[]> data() {
        ImageWriteException exception = new ImageWriteException(null);
        return Stream.of({null, "null"}, {new Object[]{1}, "[Object[]: 1]"}, {new char[]{'a', 'b', 'c'}, "[char[]: 3]"}, {new byte[]{0, 1}, "[byte[]: 2]"}, {new short[]{0}, "[short[]: 1]"}, {new int[]{-1, -2, 4, 100}, "[int[]: 4]"}, {new long[]{-1L, -2L, 4L, 100L}, "[long[]: 4]"}, {new float[]{-1.0f, 2.0f}, "[float[]: 2]"}, {new double[]{-1.0, 2.0}, "[double[]: 2]"}, {new boolean[]{true, false, true}, "[boolean[]: 3]"}, {exception, exception.getClass().getName()});
    }

    @Test
    public void testCreateExceptionWithMessage() {
        ImageWriteException exception = new ImageWriteException("imaging");
        Assertions.assertEquals((Object)"imaging", (Object)exception.getMessage());
        Assertions.assertNull((Object)exception.getCause());
    }

    @Test
    public void testCreateExceptionWithMessageAndCause() {
        ImageWriteException exception = new ImageWriteException("imaging", (Throwable)new Exception("cause"));
        Assertions.assertEquals((Object)"imaging", (Object)exception.getMessage());
        Assertions.assertNotNull((Object)exception.getCause());
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testCreateExceptionWithData(Object data, String expectedType) {
        ImageWriteException exception = new ImageWriteException("imaging", data);
        Assertions.assertEquals((Object)String.format("imaging: %s (%s)", data, expectedType), (Object)exception.getMessage());
    }
}

