/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.color;

import org.apache.commons.imaging.color.ColorCmy;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ColorCmyTest {
    private ColorCmy color;
    private ColorCmy colorCopy;

    @BeforeEach
    public void setUp() {
        this.color = new ColorCmy(1.0, 2.0, 3.0);
        this.colorCopy = new ColorCmy(1.0, 2.0, 3.0);
    }

    @Test
    public void testCAssignment() {
        Assertions.assertEquals((double)1.0, (double)this.color.C, (double)0.0);
    }

    @Test
    public void testMAssignment() {
        Assertions.assertEquals((double)2.0, (double)this.color.M, (double)0.0);
    }

    @Test
    public void testYAssignment() {
        Assertions.assertEquals((double)3.0, (double)this.color.Y, (double)0.0);
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"{C: 1.0, M: 2.0, Y: 3.0}", (Object)this.color.toString());
    }

    @Test
    public void testCreatesColorCmy() {
        ColorCmy colorCmy = new ColorCmy(0.0, -1668.733868772, -1568.733868772);
        ColorCmy colorCmyTwo = ColorCmy.YELLOW;
        Assertions.assertNotEquals((Object)colorCmy, (Object)colorCmyTwo);
        Assertions.assertEquals((double)-1568.733868772, (double)colorCmy.Y, (double)0.01);
        Assertions.assertEquals((double)-1668.733868772, (double)colorCmy.M, (double)0.01);
    }

    @Test
    public void testEquals() {
        Assertions.assertTrue((this.color.equals((Object)this.colorCopy) && this.colorCopy.equals((Object)this.color) ? 1 : 0) != 0);
        MatcherAssert.assertThat((Object)this.color.hashCode(), (Matcher)CoreMatchers.is((Object)this.colorCopy.hashCode()));
    }
}

