/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.color;

import org.apache.commons.imaging.color.ColorCieLab;
import org.apache.commons.imaging.color.ColorCieLch;
import org.apache.commons.imaging.color.ColorCieLuv;
import org.apache.commons.imaging.color.ColorCmy;
import org.apache.commons.imaging.color.ColorCmyk;
import org.apache.commons.imaging.color.ColorConversions;
import org.apache.commons.imaging.color.ColorDin99Lab;
import org.apache.commons.imaging.color.ColorHsl;
import org.apache.commons.imaging.color.ColorHsv;
import org.apache.commons.imaging.color.ColorHunterLab;
import org.apache.commons.imaging.color.ColorXyz;
import org.apache.commons.imaging.internal.Debug;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ColorConversionsTest {
    private static final int[] SAMPLE_RGBS = new int[]{-1, -16777216, -65536, -16711936, -16776961, -65281, -983296, -16711681, 0, -8421505};

    @Test
    public void testRGBtoCMYK() {
        for (int rgb : SAMPLE_RGBS) {
            ColorCmy cmy = ColorConversions.convertRGBtoCMY((int)rgb);
            ColorCmyk cmyk = ColorConversions.convertCMYtoCMYK((ColorCmy)cmy);
            ColorCmy cmyk_cmy = ColorConversions.convertCMYKtoCMY((ColorCmyk)cmyk);
            int cmyk_cmy_rgb = ColorConversions.convertCMYtoRGB((ColorCmy)cmyk_cmy);
            Debug.debug((String)("cmy: " + cmy));
            Debug.debug((String)("cmyk: " + cmyk));
            Debug.debug((String)("cmyk_cmy: " + cmyk_cmy));
            Debug.debug((String)("cmyk_cmy_rgb: " + cmyk_cmy_rgb + " (" + Integer.toHexString(cmyk_cmy_rgb) + ")"));
            Assertions.assertEquals((Object)Integer.toHexString(0xFFFFFF & rgb), (Object)Integer.toHexString(0xFFFFFF & cmyk_cmy_rgb));
        }
    }

    @Test
    public void testRGBtoHSL() {
        for (int rgb : SAMPLE_RGBS) {
            ColorHsl hsl = ColorConversions.convertRGBtoHSL((int)rgb);
            int hsl_rgb = ColorConversions.convertHSLtoRGB((ColorHsl)hsl);
            Debug.debug((String)("hsl: " + hsl));
            Debug.debug((String)("hsl_rgb: " + hsl_rgb + " (" + Integer.toHexString(hsl_rgb) + ")"));
            Assertions.assertEquals((Object)Integer.toHexString(0xFFFFFF & rgb), (Object)Integer.toHexString(0xFFFFFF & hsl_rgb));
        }
    }

    @Test
    public void testRGBtoHSV() {
        for (int rgb : SAMPLE_RGBS) {
            ColorHsv hsv = ColorConversions.convertRGBtoHSV((int)rgb);
            int hsv_rgb = ColorConversions.convertHSVtoRGB((ColorHsv)hsv);
            Debug.debug((String)("hsv: " + hsv));
            Debug.debug((String)("hsv_rgb: " + hsv_rgb + " (" + Integer.toHexString(hsv_rgb) + ")"));
            Assertions.assertEquals((Object)Integer.toHexString(0xFFFFFF & rgb), (Object)Integer.toHexString(0xFFFFFF & hsv_rgb));
        }
    }

    @Test
    public void testXYZ() {
        for (int rgb : SAMPLE_RGBS) {
            ColorXyz xyz = ColorConversions.convertRGBtoXYZ((int)rgb);
            int xyz_rgb = ColorConversions.convertXYZtoRGB((ColorXyz)xyz);
            Debug.debug();
            Debug.debug((String)("rgb: " + rgb + " (" + Integer.toHexString(rgb) + ")"));
            Debug.debug((String)("xyz: " + xyz));
            Debug.debug((String)("xyz_rgb: " + xyz_rgb + " (" + Integer.toHexString(xyz_rgb) + ")"));
            Assertions.assertEquals((Object)Integer.toHexString(0xFFFFFF & rgb), (Object)Integer.toHexString(0xFFFFFF & xyz_rgb), (String)("rgb " + Integer.toHexString(rgb) + ", " + xyz));
            ColorCieLab cielab = ColorConversions.convertXYZtoCIELab((ColorXyz)xyz);
            ColorXyz cielab_xyz = ColorConversions.convertCIELabtoXYZ((ColorCieLab)cielab);
            int cielab_xyz_rgb = ColorConversions.convertXYZtoRGB((ColorXyz)cielab_xyz);
            Debug.debug((String)("cielab: " + cielab));
            Debug.debug((String)("cielab_xyz: " + cielab_xyz));
            Debug.debug((String)("cielab_xyz_rgb: " + cielab_xyz_rgb + " (" + Integer.toHexString(cielab_xyz_rgb) + ")"));
            Assertions.assertEquals((Object)Integer.toHexString(0xFFFFFF & rgb), (Object)Integer.toHexString(0xFFFFFF & cielab_xyz_rgb));
            ColorHunterLab hunterlab = ColorConversions.convertXYZtoHunterLab((ColorXyz)xyz);
            ColorXyz hunterlab_xyz = ColorConversions.convertHunterLabtoXYZ((ColorHunterLab)hunterlab);
            int hunterlab_xyz_rgb = ColorConversions.convertXYZtoRGB((ColorXyz)hunterlab_xyz);
            Debug.debug((String)("hunterlab: " + hunterlab));
            Debug.debug((String)("hunterlab_xyz: " + hunterlab_xyz));
            Debug.debug((String)("hunterlab_xyz_rgb: " + hunterlab_xyz_rgb + " (" + Integer.toHexString(hunterlab_xyz_rgb) + ")"));
            Assertions.assertEquals((Object)Integer.toHexString(0xFFFFFF & rgb), (Object)Integer.toHexString(0xFFFFFF & hunterlab_xyz_rgb));
            ColorCieLch cielch = ColorConversions.convertCIELabtoCIELCH((ColorCieLab)cielab);
            ColorCieLab cielch_cielab = ColorConversions.convertCIELCHtoCIELab((ColorCieLch)cielch);
            Debug.debug((String)"cielch", (Object)cielch);
            Debug.debug((String)"cielch_cielab", (Object)cielch_cielab);
            ColorCieLuv cieluv = ColorConversions.convertXYZtoCIELuv((ColorXyz)xyz);
            ColorXyz cieluv_xyz = ColorConversions.convertCIELuvtoXYZ((ColorCieLuv)cieluv);
            Debug.debug((String)"cieluv", (Object)cieluv);
            Debug.debug((String)"cieluv_xyz", (Object)cieluv_xyz);
        }
    }

    @Test
    public void testRGBtoDin99b() {
        for (int rgb : SAMPLE_RGBS) {
            ColorXyz xyz = ColorConversions.convertRGBtoXYZ((int)rgb);
            ColorCieLab cielab = ColorConversions.convertXYZtoCIELab((ColorXyz)xyz);
            ColorDin99Lab din99b = ColorConversions.convertCIELabToDIN99bLab((ColorCieLab)cielab);
            ColorCieLab din99_cielab = ColorConversions.convertDIN99bLabToCIELab((ColorDin99Lab)din99b);
            ColorXyz din99_cielab_xyz = ColorConversions.convertCIELabtoXYZ((ColorCieLab)din99_cielab);
            int din99_cielab_xyz_rgb = ColorConversions.convertXYZtoRGB((ColorXyz)din99_cielab_xyz);
            Assertions.assertEquals((Object)Integer.toHexString(0xFFFFFF & rgb), (Object)Integer.toHexString(0xFFFFFF & din99_cielab_xyz_rgb));
        }
    }

    @Test
    public void testRGBtoDin99o() {
        for (int rgb : SAMPLE_RGBS) {
            ColorXyz xyz = ColorConversions.convertRGBtoXYZ((int)rgb);
            ColorCieLab cielab = ColorConversions.convertXYZtoCIELab((ColorXyz)xyz);
            ColorDin99Lab din99o = ColorConversions.convertCIELabToDIN99oLab((ColorCieLab)cielab);
            ColorCieLab din99_cielab = ColorConversions.convertDIN99oLabToCIELab((ColorDin99Lab)din99o);
            ColorXyz din99_cielab_xyz = ColorConversions.convertCIELabtoXYZ((ColorCieLab)din99_cielab);
            int din99_cielab_xyz_rgb = ColorConversions.convertXYZtoRGB((ColorXyz)din99_cielab_xyz);
            Assertions.assertEquals((Object)Integer.toHexString(0xFFFFFF & rgb), (Object)Integer.toHexString(0xFFFFFF & din99_cielab_xyz_rgb));
        }
    }
}

