/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.color;

import org.apache.commons.imaging.color.ColorHsl;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ColorHslTest {
    private ColorHsl color;
    private ColorHsl colorCopy;

    @BeforeEach
    public void setUp() {
        this.color = new ColorHsl(1.0, 2.0, 3.0);
        this.colorCopy = new ColorHsl(1.0, 2.0, 3.0);
    }

    @Test
    public void testHAssignment() {
        Assertions.assertEquals((double)1.0, (double)this.color.H, (double)0.0);
    }

    @Test
    public void testSAssignment() {
        Assertions.assertEquals((double)2.0, (double)this.color.S, (double)0.0);
    }

    @Test
    public void testLAssignment() {
        Assertions.assertEquals((double)3.0, (double)this.color.L, (double)0.0);
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"{H: 1.0, S: 2.0, L: 3.0}", (Object)this.color.toString());
    }

    @Test
    public void testHashCodeAndEquals() {
        Assertions.assertTrue((this.color.equals((Object)this.colorCopy) && this.colorCopy.equals((Object)this.color) ? 1 : 0) != 0);
        MatcherAssert.assertThat((Object)this.color.hashCode(), (Matcher)CoreMatchers.is((Object)this.colorCopy.hashCode()));
    }

    @Test
    public void testCreatesColorHslOne() {
        ColorHsl colorHsl = ColorHsl.BLUE;
        ColorHsl colorHslTwo = new ColorHsl(100.0, 667.226, -687.72287636);
        Assertions.assertEquals((double)667.226, (double)colorHslTwo.S, (double)0.01);
        Assertions.assertEquals((double)100.0, (double)colorHslTwo.H, (double)0.01);
        Assertions.assertEquals((double)-687.72287636, (double)colorHslTwo.L, (double)0.01);
        Assertions.assertNotEquals((Object)colorHsl, (Object)colorHslTwo);
    }
}

