/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.color;

import org.apache.commons.imaging.color.ColorHsv;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ColorHsvTest {
    private ColorHsv color;
    private ColorHsv colorCopy;

    @BeforeEach
    public void setUp() {
        this.color = new ColorHsv(1.0, 2.0, 3.0);
        this.colorCopy = new ColorHsv(1.0, 2.0, 3.0);
    }

    @Test
    public void testHAssignment() {
        Assertions.assertEquals((double)1.0, (double)this.color.H, (double)0.0);
    }

    @Test
    public void testSAssignment() {
        Assertions.assertEquals((double)2.0, (double)this.color.S, (double)0.0);
    }

    @Test
    public void testVAssignment() {
        Assertions.assertEquals((double)3.0, (double)this.color.V, (double)0.0);
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"{H: 1.0, S: 2.0, V: 3.0}", (Object)this.color.toString());
    }

    @Test
    public void testHashCodeAndEquals() {
        Assertions.assertTrue((this.color.equals((Object)this.colorCopy) && this.colorCopy.equals((Object)this.color) ? 1 : 0) != 0);
        MatcherAssert.assertThat((Object)this.color.hashCode(), (Matcher)CoreMatchers.is((Object)this.colorCopy.hashCode()));
    }
}

