/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.common;

import java.nio.ByteOrder;
import org.apache.commons.imaging.ImagingTest;
import org.apache.commons.imaging.common.ByteConversions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BinaryFileFunctionsTest
extends ImagingTest {
    @Test
    public void testFloatToByteConversion() {
        byte[] bytesLE = ByteConversions.toBytes((float)1.0f, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        Assertions.assertEquals((float)ByteConversions.toFloat((byte[])bytesLE, (ByteOrder)ByteOrder.LITTLE_ENDIAN), (float)1.0f, (float)0.0f);
        byte[] bytesBE = ByteConversions.toBytes((float)1.0f, (ByteOrder)ByteOrder.BIG_ENDIAN);
        Assertions.assertEquals((float)ByteConversions.toFloat((byte[])bytesBE, (ByteOrder)ByteOrder.BIG_ENDIAN), (float)1.0f, (float)0.0f);
    }

    @Test
    public void testDoubleToByteConversion() {
        byte[] bytesLE = ByteConversions.toBytes((double)1.0, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        Assertions.assertEquals((double)ByteConversions.toDouble((byte[])bytesLE, (ByteOrder)ByteOrder.LITTLE_ENDIAN), (double)1.0, (double)0.0);
        byte[] bytesBE = ByteConversions.toBytes((double)1.0, (ByteOrder)ByteOrder.BIG_ENDIAN);
        Assertions.assertEquals((double)ByteConversions.toDouble((byte[])bytesBE, (ByteOrder)ByteOrder.BIG_ENDIAN), (double)1.0, (double)0.0);
    }
}

