/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.common;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RasterFormatException;
import org.apache.commons.imaging.common.ImageBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ImageBuilderTest {
    @Test
    public void testConstructorBounds() {
        this.executeBadConstructor(0, 10);
        this.executeBadConstructor(10, 0);
    }

    @Test
    public void testBoundsCheck() {
        ImageBuilder imageBuilder = new ImageBuilder(100, 100, false);
        this.executeBadBounds(imageBuilder, -1, 0, 50, 50);
        this.executeBadBounds(imageBuilder, 0, -1, 50, 50);
        this.executeBadBounds(imageBuilder, 0, 0, 0, 50);
        this.executeBadBounds(imageBuilder, 0, 0, 50, 0);
        this.executeBadBounds(imageBuilder, 90, 0, 50, 50);
        this.executeBadBounds(imageBuilder, 0, 90, 50, 50);
    }

    @Test
    public void testSubimageAccess() {
        ImageBuilder imageBuilder = new ImageBuilder(100, 100, false);
        this.populate(imageBuilder);
        BufferedImage bImage = imageBuilder.getSubimage(25, 25, 25, 25);
        int w = bImage.getWidth();
        int h = bImage.getHeight();
        Assertions.assertEquals((int)w, (int)25, (String)"Width of subimage does not match");
        Assertions.assertEquals((int)h, (int)25, (String)"Height of subimage does not match");
        for (int x = 25; x < 50; ++x) {
            for (int y = 25; y < 50; ++y) {
                int k = bImage.getRGB(x - 25, y - 25);
                int rgb = imageBuilder.getRGB(x, y);
                Assertions.assertEquals((int)k, (int)rgb, (String)("Invalid buffered image subpixel at " + x + ", " + y));
            }
        }
        ImageBuilder testBuilder = imageBuilder.getSubset(25, 25, 25, 25);
        for (int x = 25; x < 50; ++x) {
            for (int y = 25; y < 50; ++y) {
                int k = testBuilder.getRGB(x - 25, y - 25);
                int rgb = imageBuilder.getRGB(x, y);
                Assertions.assertEquals((int)k, (int)rgb, (String)("Invalid image builder subpixel at " + x + ", " + y));
            }
        }
    }

    @Test
    void testImageColorModel() {
        ImageBuilder imageBuilder = new ImageBuilder(100, 100, false);
        BufferedImage bImage = imageBuilder.getBufferedImage();
        ColorModel model = bImage.getColorModel();
        Assertions.assertFalse((boolean)model.hasAlpha(), (String)"Output image has alpha where not specified");
        imageBuilder = new ImageBuilder(100, 100, true, false);
        bImage = imageBuilder.getBufferedImage();
        model = bImage.getColorModel();
        Assertions.assertTrue((boolean)model.hasAlpha(), (String)"Output image does not have alpha where specified");
        Assertions.assertFalse((boolean)model.isAlphaPremultiplied(), (String)"Output image has alpha pre-multiplied where not specified");
        imageBuilder = new ImageBuilder(100, 100, true, true);
        bImage = imageBuilder.getBufferedImage();
        model = bImage.getColorModel();
        Assertions.assertTrue((boolean)model.hasAlpha(), (String)"Output image does not have alpha where specified");
        Assertions.assertTrue((boolean)model.isAlphaPremultiplied(), (String)"Output image does not have alpha pre-multiplied where specified");
    }

    void executeBadBounds(ImageBuilder imageBuilder, int x, int y, int w, int h) {
        try {
            ImageBuilder sub = imageBuilder.getSubset(x, y, w, h);
            Assertions.fail((String)("Failed to detect bad bounds " + x + ", " + y + ", " + w + ", " + h));
        }
        catch (RasterFormatException rasterFormatException) {
            // empty catch block
        }
    }

    void executeBadConstructor(int w, int h) {
        try {
            ImageBuilder iBuilder = new ImageBuilder(w, h, true);
            Assertions.fail((String)("Failed to detect bad constructor " + w + ", " + h));
        }
        catch (RasterFormatException rasterFormatException) {
            // empty catch block
        }
    }

    void populate(ImageBuilder imageBuilder) {
        for (int x = 0; x < 100; ++x) {
            for (int y = 0; y < 100; ++y) {
                int k = y * 100 + x;
                int rgb = 0xFF000000 | k;
                imageBuilder.setRGB(x, y, rgb);
            }
        }
    }
}

