/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.common;

import java.text.NumberFormat;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.commons.imaging.ImagingTest;
import org.apache.commons.imaging.common.RationalNumber;
import org.apache.commons.imaging.internal.Debug;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class RationalNumberTest
extends ImagingTest {
    public static Stream<Double> data() {
        return Arrays.asList(0.0, 0.1, 0.01, 0.001, 1.0E-4, 1.0E-5, 1.0E-6, 1.0E-7, 0.123456789, 1.0, 0.9, 1.1, 2.0, 123.123, 1.23123123123E8, 0.0026927623801392356, 0.35294117647058826, 0.5, 0.3333333333333333, 0.25, 0.2, 0.16666666666666666, 0.14285714285714285, 0.125, 0.1111111111111111, 1.5, 0.6666666666666666, 0.75, 0.8, 0.8333333333333334, 0.8571428571428571, 0.875, 0.8888888888888888, 0.6, 0.5, 0.42857142857142855, 0.375, 0.3333333333333333, -0.1, -0.01, -0.001, -1.0E-4, -1.0E-5, -1.0E-6, -1.0E-7, -0.123456789, -1.0, -0.9, -1.1, -2.0, -123.123, -1.23123123123E8, 34.0, 2.147483647E9, 2.1474836471E9, 2.1474836469E9, -2.147483647E9, -2.1474836471E9, -2.1474836469E9, 9.223372036854776E18, 9.223372036854776E18, 9.223372036854776E18, -9.223372036854776E18, -9.223372036854776E18, -9.223372036854776E18).stream();
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testRationalNumber(double testValue) {
        RationalNumber rational = RationalNumber.valueOf((double)testValue);
        double difference = Math.abs(testValue - rational.doubleValue());
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(15);
        Debug.debug((String)("value: " + nf.format(testValue)));
        Debug.debug((String)("rational: " + rational));
        Debug.debug((String)("difference: " + difference));
        Debug.debug();
    }

    @Test
    public void testSpecialRationalNumber() {
        RationalNumber test = new RationalNumber(-174884065, 70000000, true);
        Assertions.assertEquals((double)58.85833187142857, (double)test.doubleValue(), (double)1.0E-14, (String)"Unsigned integer support failed for double conversion");
        Assertions.assertEquals((float)58.858334f, (float)test.floatValue(), (float)1.0E-6f, (String)"Float conversion failed");
        Assertions.assertEquals((long)58L, (long)test.longValue(), (String)"Long value conversion failed");
        Assertions.assertEquals((int)58, (int)test.intValue(), (String)"Int value conversion failed");
        Assertions.assertThrows(NumberFormatException.class, () -> test.negate(), (String)"Failed to detect negation of large unsigned value");
    }
}

