/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.common.bytesource;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.stream.Stream;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.ImageParser;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingParameters;
import org.apache.commons.imaging.common.bytesource.ByteSourceTest;
import org.apache.commons.imaging.formats.jpeg.JpegImagingParameters;
import org.apache.commons.imaging.formats.tiff.TiffImagingParameters;
import org.apache.commons.imaging.internal.Debug;
import org.apache.commons.imaging.internal.Util;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class ByteSourceImageTest
extends ByteSourceTest {
    public static Stream<File> data() throws Exception {
        return ByteSourceImageTest.getTestImages().stream();
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void test(File imageFile) throws Exception {
        Debug.debug((String)"imageFile", (Object)imageFile);
        Assertions.assertNotNull((Object)imageFile);
        byte[] imageFileBytes = FileUtils.readFileToByteArray((File)imageFile);
        Assertions.assertNotNull((Object)imageFileBytes);
        Assertions.assertEquals((long)imageFileBytes.length, (long)imageFile.length());
        if (imageFile.getName().toLowerCase().endsWith(".ico") || imageFile.getName().toLowerCase().endsWith(".tga") || imageFile.getName().toLowerCase().endsWith(".jb2") || imageFile.getName().toLowerCase().endsWith(".pcx") || imageFile.getName().toLowerCase().endsWith(".dcx") || imageFile.getName().toLowerCase().endsWith(".psd") || imageFile.getName().toLowerCase().endsWith(".wbmp") || imageFile.getName().toLowerCase().endsWith(".xbm") || imageFile.getName().toLowerCase().endsWith(".xpm")) {
            return;
        }
        this.checkGuessFormat(imageFile, imageFileBytes);
        if (imageFile.getName().toLowerCase().endsWith(".png") && imageFile.getParentFile().getName().equalsIgnoreCase("pngsuite") && imageFile.getName().toLowerCase().startsWith("x")) {
            return;
        }
        this.checkGetICCProfileBytes(imageFile, imageFileBytes);
        if (!imageFile.getParentFile().getName().toLowerCase().equals("@broken")) {
            this.checkGetImageInfo(imageFile, imageFileBytes);
        }
        this.checkGetImageSize(imageFile, imageFileBytes);
        ImageFormat imageFormat = Imaging.guessFormat((File)imageFile);
        if (ImageFormats.JPEG != imageFormat && ImageFormats.UNKNOWN != imageFormat) {
            this.checkGetBufferedImage(imageFile, imageFileBytes);
        }
    }

    public void checkGetBufferedImage(File file, byte[] bytes) throws Exception {
        BufferedImage bufferedImage = Imaging.getBufferedImage((File)file);
        Assertions.assertNotNull((Object)bufferedImage);
        Assertions.assertTrue((bufferedImage.getWidth() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((bufferedImage.getHeight() > 0 ? 1 : 0) != 0);
        int imageFileWidth = bufferedImage.getWidth();
        int imageFileHeight = bufferedImage.getHeight();
        BufferedImage imageBytes = Imaging.getBufferedImage((byte[])bytes);
        Assertions.assertNotNull((Object)imageBytes);
        Assertions.assertEquals((int)imageFileWidth, (int)imageBytes.getWidth());
        Assertions.assertEquals((int)imageFileHeight, (int)imageBytes.getHeight());
    }

    public void checkGetImageSize(File imageFile, byte[] imageFileBytes) throws Exception {
        Dimension imageSizeFile = Imaging.getImageSize((File)imageFile);
        Assertions.assertNotNull((Object)imageSizeFile);
        Assertions.assertTrue((imageSizeFile.width > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((imageSizeFile.height > 0 ? 1 : 0) != 0);
        Dimension imageSizeBytes = Imaging.getImageSize((byte[])imageFileBytes);
        Assertions.assertNotNull((Object)imageSizeBytes);
        Assertions.assertEquals((int)imageSizeFile.width, (int)imageSizeBytes.width);
        Assertions.assertEquals((int)imageSizeFile.height, (int)imageSizeBytes.height);
    }

    public void checkGuessFormat(File imageFile, byte[] imageFileBytes) throws Exception {
        ImageFormat imageFormatFile = Imaging.guessFormat((File)imageFile);
        Assertions.assertNotNull((Object)imageFormatFile);
        Assertions.assertNotSame((Object)imageFormatFile, (Object)ImageFormats.UNKNOWN);
        ImageFormat imageFormatBytes = Imaging.guessFormat((byte[])imageFileBytes);
        Assertions.assertNotNull((Object)imageFormatBytes);
        Assertions.assertNotSame((Object)imageFormatBytes, (Object)ImageFormats.UNKNOWN);
        Assertions.assertSame((Object)imageFormatBytes, (Object)imageFormatFile);
    }

    public void checkGetICCProfileBytes(File imageFile, byte[] imageFileBytes) throws Exception {
        byte[] iccBytesFile = Imaging.getICCProfileBytes((File)imageFile);
        byte[] iccBytesBytes = Imaging.getICCProfileBytes((byte[])imageFileBytes);
        Assertions.assertEquals((Object)(iccBytesFile != null ? 1 : 0), (Object)(iccBytesBytes != null ? 1 : 0));
        if (iccBytesFile == null) {
            return;
        }
        Assertions.assertArrayEquals((byte[])iccBytesFile, (byte[])iccBytesBytes);
    }

    public void checkGetImageInfo(File imageFile, byte[] imageFileBytes) throws IOException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, ImageReadException {
        Method[] methods;
        boolean ignoreImageData = this.isPhilHarveyTestImage(imageFile);
        ImageFormat imageFormat = Imaging.guessFormat((File)imageFile);
        TiffImagingParameters params = null;
        if (imageFormat == ImageFormats.TIFF) {
            params = new TiffImagingParameters();
            params.setReadThumbnails(!ignoreImageData);
        }
        if (imageFormat == ImageFormats.JPEG) {
            params = new JpegImagingParameters();
        }
        ImageParser imageParser = Util.getImageParser((ImageFormat)imageFormat);
        ImageInfo imageInfoFile = imageParser.getImageInfo(imageFile, (ImagingParameters)params);
        ImageInfo imageInfoBytes = imageParser.getImageInfo(imageFileBytes, (ImagingParameters)params);
        Assertions.assertNotNull((Object)imageInfoFile);
        Assertions.assertNotNull((Object)imageInfoBytes);
        for (Method method2 : methods = ImageInfo.class.getMethods()) {
            if (!Modifier.isPublic(method2.getModifiers()) || !method2.getName().startsWith("get") || method2.getName().equals("getClass")) continue;
            Object valueFile = method2.invoke((Object)imageInfoFile, (Object[])null);
            Object valueBytes = method2.invoke((Object)imageInfoBytes, (Object[])null);
            Assertions.assertEquals((Object)valueFile, (Object)valueBytes);
        }
        Assertions.assertTrue((imageInfoFile.getBitsPerPixel() > 0 ? 1 : 0) != 0);
        Assertions.assertNotNull((Object)imageInfoFile.getFormat());
        Assertions.assertNotSame((Object)imageInfoFile.getFormat(), (Object)ImageFormats.UNKNOWN);
        Assertions.assertNotNull((Object)imageInfoFile.getFormatName());
        Assertions.assertTrue((imageInfoFile.getWidth() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((imageInfoFile.getHeight() > 0 ? 1 : 0) != 0);
        Assertions.assertNotNull((Object)imageInfoFile.getMimeType());
    }
}

