/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.common.bytesource;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingTestConstants;
import org.apache.commons.io.FilenameUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ByteSourceInputStreamTest {
    public static final String ICO_IMAGE_FILE = "ico\\1\\Oregon Scientific DS6639 - DSC_0307 - small.ico";
    public static final int ICO_IMAGE_WIDTH = 300;
    public static final int ICO_IMAGE_HEIGHT = 225;

    ByteSourceInputStreamTest() {
    }

    @Test
    public void testReadFromStream() throws IOException, ImageReadException {
        String imagePath = FilenameUtils.separatorsToSystem((String)ICO_IMAGE_FILE);
        File imageFile = new File(ImagingTestConstants.TEST_IMAGE_FOLDER, imagePath);
        try (BufferedInputStream imageStream = new BufferedInputStream(new FileInputStream(imageFile));){
            BufferedImage bufferedImage = Imaging.getBufferedImage((InputStream)imageStream, (String)ICO_IMAGE_FILE);
            Assertions.assertEquals((int)bufferedImage.getWidth(), (int)300);
            Assertions.assertEquals((int)bufferedImage.getHeight(), (int)225);
        }
    }
}

