/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.common.bytesource;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.imaging.ImagingConstants;
import org.apache.commons.imaging.ImagingTest;
import org.apache.commons.imaging.common.bytesource.ByteSourceArray;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class ByteSourceTest
extends ImagingTest {
    protected File createTempFile(byte[] src) throws IOException {
        File file = File.createTempFile("raw_", ".bin");
        try (FileOutputStream fos = new FileOutputStream(file);
             BufferedOutputStream os = new BufferedOutputStream(fos);){
            ((OutputStream)os).write(src);
        }
        Assertions.assertEquals((long)src.length, (long)file.length());
        return file;
    }

    protected static byte[][] getTestByteArrays() {
        byte[] single = new byte[1];
        for (int i = 0; i < single.length; ++i) {
            single[i] = (byte)i;
        }
        byte[] simple = new byte[256];
        for (int i = 0; i < simple.length; ++i) {
            simple[i] = (byte)i;
        }
        byte[] zeroes = new byte[256];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < 65536; ++i) {
            baos.write(0xFF & i);
            baos.write(0xFF & i >> 8);
        }
        byte[] longArray = baos.toByteArray();
        return new byte[][]{ImagingConstants.EMPTY_BYTE_ARRAY, single, simple, zeroes, longArray};
    }

    @Test
    public void testGetInputStreamThrowsNullPointerException() {
        ByteSourceArray byteSourceArray = new ByteSourceArray(null);
        Assertions.assertThrows(NullPointerException.class, () -> byteSourceArray.getInputStream(0L));
    }
}

