/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.examples;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.ImagingParameters;
import org.apache.commons.imaging.common.BufferedImageFactory;
import org.apache.commons.imaging.formats.tiff.TiffImageParser;
import org.apache.commons.imaging.formats.tiff.TiffImagingParameters;

public class ImageReadExample {
    public static BufferedImage imageReadExample(File file) throws ImageReadException, IOException {
        TiffImagingParameters params = new TiffImagingParameters();
        params.setBufferedImageFactory((BufferedImageFactory)new ManagedImageBufferedImageFactory());
        return new TiffImageParser().getBufferedImage(file, (ImagingParameters)params);
    }

    public static class ManagedImageBufferedImageFactory
    implements BufferedImageFactory {
        public BufferedImage getColorBufferedImage(int width, int height, boolean hasAlpha) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gd = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            return gc.createCompatibleImage(width, height, 3);
        }

        public BufferedImage getGrayscaleBufferedImage(int width, int height, boolean hasAlpha) {
            return this.getColorBufferedImage(width, height, hasAlpha);
        }
    }
}

