/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.examples;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.common.RationalNumber;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.constants.ExifTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.GpsTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;

public class MetadataExample {
    public static void metadataExample(File file) throws ImageReadException, IOException {
        ImageMetadata metadata = Imaging.getMetadata((File)file);
        if (metadata instanceof JpegImageMetadata) {
            TiffImageMetadata.GPSInfo gpsInfo;
            JpegImageMetadata jpegMetadata = (JpegImageMetadata)metadata;
            System.out.println("file: " + file.getPath());
            MetadataExample.printTagValue(jpegMetadata, (TagInfo)TiffTagConstants.TIFF_TAG_XRESOLUTION);
            MetadataExample.printTagValue(jpegMetadata, (TagInfo)TiffTagConstants.TIFF_TAG_DATE_TIME);
            MetadataExample.printTagValue(jpegMetadata, (TagInfo)ExifTagConstants.EXIF_TAG_DATE_TIME_ORIGINAL);
            MetadataExample.printTagValue(jpegMetadata, (TagInfo)ExifTagConstants.EXIF_TAG_DATE_TIME_DIGITIZED);
            MetadataExample.printTagValue(jpegMetadata, (TagInfo)ExifTagConstants.EXIF_TAG_ISO);
            MetadataExample.printTagValue(jpegMetadata, (TagInfo)ExifTagConstants.EXIF_TAG_SHUTTER_SPEED_VALUE);
            MetadataExample.printTagValue(jpegMetadata, (TagInfo)ExifTagConstants.EXIF_TAG_APERTURE_VALUE);
            MetadataExample.printTagValue(jpegMetadata, (TagInfo)ExifTagConstants.EXIF_TAG_BRIGHTNESS_VALUE);
            MetadataExample.printTagValue(jpegMetadata, (TagInfo)GpsTagConstants.GPS_TAG_GPS_LATITUDE_REF);
            MetadataExample.printTagValue(jpegMetadata, (TagInfo)GpsTagConstants.GPS_TAG_GPS_LATITUDE);
            MetadataExample.printTagValue(jpegMetadata, (TagInfo)GpsTagConstants.GPS_TAG_GPS_LONGITUDE_REF);
            MetadataExample.printTagValue(jpegMetadata, (TagInfo)GpsTagConstants.GPS_TAG_GPS_LONGITUDE);
            System.out.println();
            TiffImageMetadata exifMetadata = jpegMetadata.getExif();
            if (null != exifMetadata && null != (gpsInfo = exifMetadata.getGPS())) {
                String gpsDescription = gpsInfo.toString();
                double longitude = gpsInfo.getLongitudeAsDegreesEast();
                double latitude = gpsInfo.getLatitudeAsDegreesNorth();
                System.out.println("    GPS Description: " + gpsDescription);
                System.out.println("    GPS Longitude (Degrees East): " + longitude);
                System.out.println("    GPS Latitude (Degrees North): " + latitude);
            }
            TiffField gpsLatitudeRefField = jpegMetadata.findEXIFValueWithExactMatch((TagInfo)GpsTagConstants.GPS_TAG_GPS_LATITUDE_REF);
            TiffField gpsLatitudeField = jpegMetadata.findEXIFValueWithExactMatch((TagInfo)GpsTagConstants.GPS_TAG_GPS_LATITUDE);
            TiffField gpsLongitudeRefField = jpegMetadata.findEXIFValueWithExactMatch((TagInfo)GpsTagConstants.GPS_TAG_GPS_LONGITUDE_REF);
            TiffField gpsLongitudeField = jpegMetadata.findEXIFValueWithExactMatch((TagInfo)GpsTagConstants.GPS_TAG_GPS_LONGITUDE);
            if (gpsLatitudeRefField != null && gpsLatitudeField != null && gpsLongitudeRefField != null && gpsLongitudeField != null) {
                String gpsLatitudeRef = (String)gpsLatitudeRefField.getValue();
                RationalNumber[] gpsLatitude = (RationalNumber[])gpsLatitudeField.getValue();
                String gpsLongitudeRef = (String)gpsLongitudeRefField.getValue();
                RationalNumber[] gpsLongitude = (RationalNumber[])gpsLongitudeField.getValue();
                RationalNumber gpsLatitudeDegrees = gpsLatitude[0];
                RationalNumber gpsLatitudeMinutes = gpsLatitude[1];
                RationalNumber gpsLatitudeSeconds = gpsLatitude[2];
                RationalNumber gpsLongitudeDegrees = gpsLongitude[0];
                RationalNumber gpsLongitudeMinutes = gpsLongitude[1];
                RationalNumber gpsLongitudeSeconds = gpsLongitude[2];
                System.out.println("    GPS Latitude: " + gpsLatitudeDegrees.toDisplayString() + " degrees, " + gpsLatitudeMinutes.toDisplayString() + " minutes, " + gpsLatitudeSeconds.toDisplayString() + " seconds " + gpsLatitudeRef);
                System.out.println("    GPS Longitude: " + gpsLongitudeDegrees.toDisplayString() + " degrees, " + gpsLongitudeMinutes.toDisplayString() + " minutes, " + gpsLongitudeSeconds.toDisplayString() + " seconds " + gpsLongitudeRef);
            }
            System.out.println();
            List items = jpegMetadata.getItems();
            for (ImageMetadata.ImageMetadataItem item : items) {
                System.out.println("    item: " + item);
            }
            System.out.println();
        }
    }

    private static void printTagValue(JpegImageMetadata jpegMetadata, TagInfo tagInfo) {
        TiffField field = jpegMetadata.findEXIFValueWithExactMatch(tagInfo);
        if (field == null) {
            System.out.println(tagInfo.name + ": Not Found.");
        } else {
            System.out.println(tagInfo.name + ": " + field.getValueDescription());
        }
    }
}

