/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.examples.tiff;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.imaging.FormatCompliance;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.common.bytesource.ByteSourceFile;
import org.apache.commons.imaging.formats.tiff.TiffContents;
import org.apache.commons.imaging.formats.tiff.TiffDirectory;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.TiffImagingParameters;
import org.apache.commons.imaging.formats.tiff.TiffReader;
import org.apache.commons.imaging.formats.tiff.constants.GdalLibraryTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.GeoTiffTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;

public class ReadTagsAndImages {
    private static final String[] USAGE = new String[]{"Usage ReadTagsAndImages <input file>  [output file]", "   input file: mandatory file to be read", "   output file: optional root name and path for files to be written"};
    private static HashMap<Integer, GeoKey> keyMap;
    private static String nameFormat;

    public static void main(String[] args) throws ImageReadException, IOException {
        if (args.length == 0) {
            for (String s : USAGE) {
                System.err.println(s);
            }
            System.exit(0);
        }
        PrintStream ps = System.out;
        File target = new File(args[0]);
        String rootName = null;
        if (args.length == 2) {
            rootName = args[1];
        }
        boolean optionalImageReadingEnabled = rootName != null && !rootName.isEmpty();
        ByteSourceFile byteSource = new ByteSourceFile(target);
        TiffImagingParameters params = new TiffImagingParameters();
        TiffReader tiffReader = new TiffReader(true);
        TiffContents contents = tiffReader.readDirectories((ByteSource)byteSource, optionalImageReadingEnabled, FormatCompliance.getDefault());
        int iDirectory = 0;
        for (TiffDirectory directory : contents.directories) {
            boolean hasTiffImageData = directory.hasTiffImageData();
            if (iDirectory > 0) {
                ps.println("\n-----------------------------------------------------\n");
            }
            String contentType = "";
            if (directory.hasTiffRasterData()) {
                contentType = "Numeric raster data";
            } else if (directory.hasTiffImageData()) {
                contentType = "Image data";
            }
            ps.format("Directory %2d %s, description: %s%n", iDirectory, contentType, directory.description());
            List fieldList = directory.getDirectoryEntries();
            for (TiffField tiffField : fieldList) {
                String s = tiffField.toString();
                if (s.length() > 90) {
                    s = s.substring(0, 90);
                }
                if (tiffField.getTag() == 324 || tiffField.getTag() == 325) {
                    int i = s.indexOf(41);
                    int[] a = tiffField.getIntArrayValue();
                    s = s.substring(0, i + 2) + " [" + a.length + " entries]";
                }
                ps.println(" " + s);
            }
            ReadTagsAndImages.summarizeGeoTiffTags(ps, directory);
            if (optionalImageReadingEnabled && hasTiffImageData) {
                File output = new File(rootName + "_" + iDirectory + ".jpg");
                ps.println("Writing image to " + output.getPath());
                BufferedImage bImage = directory.getTiffImage(params);
                ImageIO.write((RenderedImage)bImage, "JPEG", output);
            }
            ps.println("");
            ++iDirectory;
        }
    }

    private static void summarizeGeoTiffTags(PrintStream ps, TiffDirectory directory) throws ImageReadException {
        TiffField modelTransformField;
        int j;
        short[] geoKeyDirectory;
        if (keyMap == null) {
            GeoKey[] values = GeoKey.values();
            int maxNameLength = 0;
            keyMap = new HashMap();
            for (GeoKey g : values) {
                String name = g.name();
                if (name.length() > maxNameLength) {
                    maxNameLength = name.length();
                }
                keyMap.put(g.key, g);
            }
            nameFormat = String.format("   %%-%ds", maxNameLength);
        }
        if ((geoKeyDirectory = directory.getFieldValue(GeoTiffTagConstants.EXIF_TAG_GEO_KEY_DIRECTORY_TAG, false)) == null || geoKeyDirectory.length < 4) {
            return;
        }
        ps.println("");
        ps.println("Summary of GeoTIFF Elements ----------------------------");
        short[] bitsPerSample = directory.getFieldValue(TiffTagConstants.TIFF_TAG_BITS_PER_SAMPLE, false);
        short[] sampleFormat = directory.getFieldValue(TiffTagConstants.TIFF_TAG_SAMPLE_FORMAT, false);
        String contentTypeString = null;
        if (bitsPerSample != null && sampleFormat != null) {
            if (bitsPerSample[0] == 16 && sampleFormat[0] == 2) {
                contentTypeString = "Numeric, Short Integer";
            } else if ((bitsPerSample[0] == 32 || bitsPerSample[0] == 64) && sampleFormat[0] == 3) {
                contentTypeString = "Numeric, Floating Point (" + bitsPerSample[0] + "-bit samples)";
            }
        }
        if (contentTypeString != null) {
            ps.format("%nContent Type: %s", contentTypeString);
            String[] gdalNoDataString = directory.getFieldValue(GdalLibraryTagConstants.EXIF_TAG_GDAL_NO_DATA, false);
            if (gdalNoDataString != null && gdalNoDataString.length > 0) {
                ps.format("    GDAL No-Data value: %s", gdalNoDataString[0]);
            }
            ps.format("%n", new Object[0]);
        }
        int[] elements = new int[geoKeyDirectory.length];
        for (int i = 0; i < geoKeyDirectory.length; ++i) {
            elements[i] = geoKeyDirectory[i] & 0xFFFF;
        }
        TiffField doubleParametersField = directory.findField((TagInfo)GeoTiffTagConstants.EXIF_TAG_GEO_DOUBLE_PARAMS_TAG);
        double[] doubleParameters = null;
        if (doubleParametersField != null) {
            doubleParameters = doubleParametersField.getDoubleArrayValue();
        }
        TiffField asciiParametersField = directory.findField((TagInfo)GeoTiffTagConstants.EXIF_TAG_GEO_ASCII_PARAMS_TAG);
        String asciiParameters = null;
        if (asciiParametersField != null) {
            asciiParameters = asciiParametersField.getStringValue();
        }
        ps.format("%nGeoKey Table%n", new Object[0]);
        ps.println("     key     ref     len   value/pos     name");
        int k = 0;
        int n = elements.length / 4;
        for (int i = 0; i < n; ++i) {
            String interpretation;
            String name;
            int key = elements[k];
            int ref = elements[k + 1];
            int len = elements[k + 2];
            int vop = elements[k + 3];
            String label = "";
            if (ref == GeoTiffTagConstants.EXIF_TAG_GEO_ASCII_PARAMS_TAG.tag) {
                label = "(A)";
            } else if (ref == GeoTiffTagConstants.EXIF_TAG_GEO_DOUBLE_PARAMS_TAG.tag) {
                label = "(D)";
            }
            for (j = 0; j < 4; ++j) {
                ps.format("%8d", elements[k++]);
            }
            ps.format("   %-3s", label);
            if (i == 0) {
                name = "~~~";
                interpretation = "~~~";
            } else {
                GeoKey geoKey = keyMap.get(key);
                if (geoKey == null) {
                    name = "Unknown GeoKey";
                    interpretation = "~~~";
                } else {
                    name = geoKey.name();
                    interpretation = ReadTagsAndImages.interpretElements(geoKey, ref, len, vop, doubleParameters, asciiParameters);
                }
            }
            ps.format(nameFormat, name);
            ps.format("%s", interpretation);
            ps.format("%n", new Object[0]);
        }
        TiffField pixelScaleField = directory.findField((TagInfo)GeoTiffTagConstants.EXIF_TAG_MODEL_PIXEL_SCALE_TAG);
        if (pixelScaleField == null) {
            ps.format("%nModelPixelScale is not supplied%n", new Object[0]);
        } else {
            double[] pixelScale = pixelScaleField.getDoubleArrayValue();
            ps.format("%nModelPixelScale%n", new Object[0]);
            for (int i = 0; i < pixelScale.length; ++i) {
                ps.format("   %15.10e", pixelScale[i]);
            }
            ps.format("%n", new Object[0]);
        }
        TiffField modelTiepointField = directory.findField((TagInfo)GeoTiffTagConstants.EXIF_TAG_MODEL_TIEPOINT_TAG);
        if (modelTiepointField != null) {
            ps.format("%nModelTiepointTag%n", new Object[0]);
            ps.println("           Pixel                           Model");
            double[] tiePoints = modelTiepointField.getDoubleArrayValue();
            n = tiePoints.length / 6;
            for (int i = 0; i < n; ++i) {
                int j2;
                ps.format("   ", new Object[0]);
                for (j2 = 0; j2 < 3; ++j2) {
                    ps.format("%6.1f", tiePoints[i * 6 + j2]);
                }
                ps.format("     ", new Object[0]);
                for (j2 = 3; j2 < 6; ++j2) {
                    ps.format("%13.3f", tiePoints[i * 6 + j2]);
                }
                ps.format("%n", new Object[0]);
            }
        }
        if ((modelTransformField = directory.findField((TagInfo)GeoTiffTagConstants.EXIF_TAG_MODEL_TRANSFORMATION_TAG)) != null) {
            ps.format("%nModelTransformationTag%n", new Object[0]);
            double[] mtf = modelTiepointField.getDoubleArrayValue();
            if (mtf.length >= 16) {
                for (int i = 0; i < 4; ++i) {
                    ps.format("   ", new Object[0]);
                    for (j = 0; j < 4; ++j) {
                        ps.format("%13.3f", mtf[i * 4 + j]);
                    }
                    ps.format("%n", new Object[0]);
                }
            }
        }
    }

    private static String interpretElements(GeoKey geoKey, int ref, int len, int valueOrPosition, double[] doubleParameters, String asciiParameters) {
        switch (geoKey) {
            case GTModelTypeGeoKey: {
                switch (valueOrPosition) {
                    case 1: {
                        return "Projected Coordinate System";
                    }
                    case 2: {
                        return "Geographic Coordinate System";
                    }
                    case 3: {
                        return "Geocentric Coordinate System";
                    }
                }
            }
            case GTRasterTypeGeoKey: {
                switch (valueOrPosition) {
                    case 1: {
                        return "RasterPixelIsArea";
                    }
                    case 2: {
                        return "RasterPixelIsPoint";
                    }
                }
                return "User Defined";
            }
            case GeographicTypeGeoKey: {
                switch (valueOrPosition) {
                    case 4269: {
                        return "North American Datum 1983";
                    }
                    case 4030: {
                        return "World Geodetic Survey 1984";
                    }
                    case 4326: {
                        return "EPSG 4326, Geographic 2D WGS 84";
                    }
                }
            }
            case GTCitationGeoKey: {
                return ReadTagsAndImages.extractAscii(asciiParameters, valueOrPosition, len);
            }
            case GeogCitationGeoKey: {
                return ReadTagsAndImages.extractAscii(asciiParameters, valueOrPosition, len);
            }
            case GeogAngularUnitsGeoKey: {
                switch (valueOrPosition) {
                    case 9101: {
                        return "Radians";
                    }
                    case 9102: {
                        return "Degrees";
                    }
                }
            }
            case GeogSemiMajorAxisGeoKey: {
                return ReadTagsAndImages.extractDouble(doubleParameters, valueOrPosition, len);
            }
            case GeogInvFlatteningGeoKey: {
                return ReadTagsAndImages.extractDouble(doubleParameters, valueOrPosition, len);
            }
            case To_WGS84_GeoKey: {
                return ReadTagsAndImages.extractDouble(doubleParameters, valueOrPosition, len);
            }
            case ProjectedCRSGeoKey: {
                if (0 <= valueOrPosition && valueOrPosition <= 1023) {
                    return "Reserved";
                }
                if (1024 <= valueOrPosition && valueOrPosition <= 32766) {
                    return "EPSG Code #" + valueOrPosition;
                }
                if (valueOrPosition != Short.MAX_VALUE) break;
                return "User-Defined Projection";
            }
            case ProjectionGeoKey: {
                if (valueOrPosition != Short.MAX_VALUE) break;
                return "User-Defined";
            }
            case ProjCoordTransGeoKey: {
                CoordinateTransformationCode code = CoordinateTransformationCode.getValueForKey(valueOrPosition);
                if (code == null) break;
                return code.name();
            }
            case ProjLinearUnitsGeoKey: {
                switch (valueOrPosition) {
                    case 9001: {
                        return "Meter";
                    }
                    case 9002: {
                        return "Foot";
                    }
                    case 9003: {
                        return "Survey Foot";
                    }
                }
                break;
            }
            case ProjStdParallel1GeoKey: 
            case ProjStdParallel2GeoKey: 
            case ProjNatOriginLongGeoKey: 
            case ProjFalseEastingGeoKey: 
            case ProjFalseNorthingGeoKey: 
            case ProjFalseOriginLongGeoKey: 
            case ProjFalseOriginLatGeoKey: 
            case ProjFalseOriginEastingGeoKey: 
            case ProjFalseOriginNorthingGeoKey: 
            case ProjCenterLongGeoKey: 
            case ProjCenterLatGeoKey: {
                return String.format("%13.4f", doubleParameters[valueOrPosition]);
            }
        }
        return "See GeoTIFF specification";
    }

    private static String extractAscii(String asciiParameters, int pos, int len) {
        if (asciiParameters != null && len > 0 && pos + len <= asciiParameters.length()) {
            return asciiParameters.substring(pos, pos + len - 1);
        }
        return "~~~";
    }

    private static String extractDouble(double[] doubleParameters, int pos, int len) {
        if (doubleParameters != null && doubleParameters.length >= pos + len) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < len && i < 3; ++i) {
                if (i > 0) {
                    sb.append(" | ");
                }
                sb.append(Double.toString(doubleParameters[pos + i]));
            }
            if (len > 3) {
                sb.append(" | ...");
            }
            return sb.toString();
        }
        return "~~~";
    }

    static enum CoordinateTransformationCode {
        TransverseMercator(1),
        TransvMercator_Modified_Alaska(2),
        ObliqueMercator(3),
        ObliqueMercator_Laborde(4),
        ObliqueMercator_Rosenmund(5),
        ObliqueMercator_Spherical(6),
        Mercator(7),
        LambertConfConic_2SP(8),
        LambertConfConic_Helmert(9),
        LambertAzimEqualArea(10),
        AlbersEqualArea(11),
        AzimuthalEquidistant(12),
        EquidistantConic(13),
        Stereographic(14),
        PolarStereographic(15),
        ObliqueStereographic(16),
        Equirectangular(17),
        CassiniSoldner(18),
        Gnomonic(19),
        MillerCylindrical(20),
        Orthographic(21),
        Polyconic(22),
        Robinson(23),
        Sinusoidal(24),
        VanDerGrinten(25),
        NewZealandMapGrid(26),
        TransvMercator_SouthOriented(27);

        int key;

        private CoordinateTransformationCode(int key) {
            this.key = key;
        }

        static CoordinateTransformationCode getValueForKey(int key) {
            for (CoordinateTransformationCode v : CoordinateTransformationCode.values()) {
                if (v.key != key) continue;
                return v;
            }
            return null;
        }
    }

    static enum GeoKey {
        GTModelTypeGeoKey(1024),
        GTRasterTypeGeoKey(1025),
        GTCitationGeoKey(1026),
        GeographicTypeGeoKey(2048),
        GeogCitationGeoKey(2049),
        GeogGeodeticDatumGeoKey(2050),
        GeogPrimeMeridianGeoKey(2051),
        GeogLinearUnitsGeoKey(2052),
        GeogLinearUnitSizeGeoKey(2053),
        GeogAngularUnitsGeoKey(2054),
        GeogAngularUnitSizeGeoKey(2055),
        GeogEllipsoidGeoKey(2056),
        GeogSemiMajorAxisGeoKey(2057),
        GeogSemiMinorAxisGeoKey(2058),
        GeogInvFlatteningGeoKey(2059),
        GeogAzimuthUnitsGeoKey(2060),
        GeogPrimeMeridianLongGeoKey(2061),
        ProjectedCRSGeoKey(3072),
        PCSCitationGeoKey(3073),
        ProjectionGeoKey(3074),
        ProjCoordTransGeoKey(3075),
        ProjLinearUnitsGeoKey(3076),
        ProjLinearUnitSizeGeoKey(3077),
        ProjStdParallel1GeoKey(3078),
        ProjStdParallel2GeoKey(3079),
        ProjNatOriginLongGeoKey(3080),
        ProjNatOriginLatGeoKey(3081),
        ProjFalseEastingGeoKey(3082),
        ProjFalseNorthingGeoKey(3083),
        ProjFalseOriginLongGeoKey(3084),
        ProjFalseOriginLatGeoKey(3085),
        ProjFalseOriginEastingGeoKey(3086),
        ProjFalseOriginNorthingGeoKey(3087),
        ProjCenterLongGeoKey(3088),
        ProjCenterLatGeoKey(3089),
        ProjCenterEastingGeoKey(3090),
        ProjCenterNorthingGeoKey(3091),
        ProjScaleAtNatOriginGeoKey(3092),
        ProjScaleAtCenterGeoKey(3093),
        ProjAzimuthAngleGeoKey(3094),
        ProjStraightVertPoleLongGeoKey(3095),
        VerticalCSTypeGeoKey(4096),
        VerticalCitationGeoKey(4097),
        VerticalDatumGeoKey(4098),
        VerticalUnitsGeoKey(4099),
        To_WGS84_GeoKey(2062);

        int key;

        private GeoKey(int key) {
            this.key = key;
        }
    }
}

