/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.examples.tiff;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Formatter;
import org.apache.commons.imaging.FormatCompliance;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.common.bytesource.ByteSourceFile;
import org.apache.commons.imaging.formats.tiff.TiffContents;
import org.apache.commons.imaging.formats.tiff.TiffDirectory;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.TiffReader;
import org.apache.commons.imaging.formats.tiff.constants.TiffEpTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.TiffPlanarConfiguration;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoBytes;

public class SurveyTiffFile {
    public String surveyFile(File file, boolean csv) throws ImageReadException, IOException {
        String delimiter = "  ";
        if (csv) {
            delimiter = ", ";
        }
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb);
        ByteSourceFile byteSource = new ByteSourceFile(file);
        TiffReader tiffReader = new TiffReader(true);
        TiffContents contents = tiffReader.readDirectories((ByteSource)byteSource, false, FormatCompliance.getDefault());
        if (contents.directories.isEmpty()) {
            throw new ImageReadException("No Image File Directory (IFD) found");
        }
        TiffDirectory directory = (TiffDirectory)contents.directories.get(0);
        boolean hasTiffImageData = directory.hasTiffImageData();
        if (!hasTiffImageData) {
            throw new ImageReadException("No image data in file");
        }
        int width = directory.getSingleFieldValue(TiffTagConstants.TIFF_TAG_IMAGE_WIDTH);
        int height = directory.getSingleFieldValue(TiffTagConstants.TIFF_TAG_IMAGE_LENGTH);
        int samplesPerPixel = 1;
        TiffField samplesPerPixelField = directory.findField((TagInfo)TiffTagConstants.TIFF_TAG_SAMPLES_PER_PIXEL);
        if (samplesPerPixelField != null) {
            samplesPerPixel = samplesPerPixelField.getIntValue();
        }
        int[] bitsPerSample = new int[]{1};
        int bitsPerPixel = samplesPerPixel;
        TiffField bitsPerSampleField = directory.findField((TagInfo)TiffTagConstants.TIFF_TAG_BITS_PER_SAMPLE);
        if (bitsPerSampleField != null) {
            bitsPerSample = bitsPerSampleField.getIntArrayValue();
            bitsPerPixel = bitsPerSampleField.getIntValueOrArraySum();
        }
        if (samplesPerPixel != bitsPerSample.length) {
            throw new ImageReadException("Tiff: samplesPerPixel (" + samplesPerPixel + ")!=fBitsPerSample.length (" + bitsPerSample.length + ")");
        }
        int rowsPerStrip = 0;
        int tileWidth = 0;
        int tileHeight = 0;
        boolean imageDataInStrips = directory.imageDataInStrips();
        if (imageDataInStrips) {
            TiffField rowsPerStripField = directory.findField((TagInfo)TiffTagConstants.TIFF_TAG_ROWS_PER_STRIP);
            rowsPerStrip = Integer.MAX_VALUE;
            if (null != rowsPerStripField) {
                rowsPerStrip = rowsPerStripField.getIntValue();
            } else {
                TiffField imageHeight = directory.findField((TagInfo)TiffTagConstants.TIFF_TAG_IMAGE_LENGTH);
                if (imageHeight != null) {
                    rowsPerStrip = imageHeight.getIntValue();
                }
            }
        } else {
            TiffField tileWidthField = directory.findField((TagInfo)TiffTagConstants.TIFF_TAG_TILE_WIDTH);
            if (null == tileWidthField) {
                throw new ImageReadException("Can't find tile width field.");
            }
            tileWidth = tileWidthField.getIntValue();
            TiffField tileLengthField = directory.findField((TagInfo)TiffTagConstants.TIFF_TAG_TILE_LENGTH);
            if (null == tileLengthField) {
                throw new ImageReadException("Can't find tile length field.");
            }
            tileHeight = tileLengthField.getIntValue();
        }
        String compressionString = this.getCompressionString(directory);
        String predictorString = this.getPredictorString(directory);
        String planarConfigurationString = this.getPlanarConfigurationString(directory);
        String bitsPerSampleString = this.getBitsPerSampleString(bitsPerSample);
        String sampleFmtString = this.getSampleFormatString(directory);
        String piString = this.getPhotometricInterpreterString(directory, bitsPerSample);
        String iccString = this.getIccProfileString(directory);
        fmt.format("%s%4dx%-4d", delimiter, width, height);
        if (imageDataInStrips) {
            fmt.format("%sStrips%s%4dx%-4d", delimiter, delimiter, width, rowsPerStrip);
        } else {
            fmt.format("%sTiles %s%4dx%-4d", delimiter, delimiter, tileWidth, tileHeight);
        }
        fmt.format("%s%s", delimiter, planarConfigurationString);
        fmt.format("%s%-8s", delimiter, compressionString);
        fmt.format("%s%-7s", delimiter, predictorString);
        fmt.format("%s%-8s", delimiter, sampleFmtString);
        fmt.format("%s%3d", delimiter, bitsPerPixel);
        fmt.format("%s%-7s", delimiter, bitsPerSampleString);
        fmt.format("%s%-9s", delimiter, piString);
        fmt.format("%s%-7s", delimiter, iccString);
        if (csv) {
            return this.trimForCsv(sb);
        }
        return sb.toString();
    }

    private String getCompressionString(TiffDirectory directory) throws ImageReadException {
        short compressionFieldValue = directory.findField((TagInfo)TiffTagConstants.TIFF_TAG_COMPRESSION) != null ? directory.getFieldValue(TiffTagConstants.TIFF_TAG_COMPRESSION) : (short)1;
        int compression = 0xFFFF & compressionFieldValue;
        switch (compression) {
            case 1: {
                return "None";
            }
            case 2: {
                return "CCITT_1D";
            }
            case 3: {
                return "CCITT_3";
            }
            case 4: {
                return "CCITT_4";
            }
            case 5: {
                return "LZW";
            }
            case 32773: {
                return "PACKBITS";
            }
            case 8: 
            case 32946: {
                return "Deflate";
            }
        }
        return "None";
    }

    String getPredictorString(TiffDirectory directory) throws ImageReadException {
        int predictor = -1;
        TiffField predictorField = directory.findField((TagInfo)TiffTagConstants.TIFF_TAG_PREDICTOR);
        if (null != predictorField) {
            predictor = predictorField.getIntValueOrArraySum();
        }
        switch (predictor) {
            case 2: {
                return "Diff";
            }
            case 3: {
                return "FP Diff";
            }
        }
        return "None";
    }

    String getSampleFormatString(TiffDirectory directory) throws ImageReadException {
        short[] sSampleFmt = directory.getFieldValue(TiffTagConstants.TIFF_TAG_SAMPLE_FORMAT, false);
        if (sSampleFmt == null || sSampleFmt.length == 0) {
            return "Unknown";
        }
        String heterogeneous = "";
        for (int i = 1; i < sSampleFmt.length; ++i) {
            if (sSampleFmt[i] == sSampleFmt[0]) continue;
            heterogeneous = "*";
            break;
        }
        short test = sSampleFmt[0];
        switch (test) {
            case 5: {
                return "Comp I" + heterogeneous;
            }
            case 3: {
                return "Float" + heterogeneous;
            }
            case 6: {
                return "Comp F" + heterogeneous;
            }
            case 2: {
                return "Sgn Int" + heterogeneous;
            }
            case 1: {
                return "Uns Int" + heterogeneous;
            }
        }
        return "Unknown" + heterogeneous;
    }

    String getBitsPerSampleString(int[] bitsPerSample) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < bitsPerSample.length; ++i) {
            if (i > 0) {
                s.append(".");
            }
            s.append(Integer.toString(bitsPerSample[i], 10));
        }
        return s.toString();
    }

    private String getPhotometricInterpreterString(TiffDirectory directory, int[] bitsPerSample) throws ImageReadException {
        int photometricInterpretation = 0xFFFF & directory.getFieldValue(TiffTagConstants.TIFF_TAG_PHOTOMETRIC_INTERPRETATION);
        switch (photometricInterpretation) {
            case 0: {
                return "BiLev Inv";
            }
            case 1: {
                return "BiLevel";
            }
            case 2: {
                String a = "RGB";
                if (bitsPerSample.length == 4) {
                    Object o = directory.getFieldValue((TagInfo)TiffTagConstants.TIFF_TAG_EXTRA_SAMPLES);
                    short extraSamples = 0;
                    if (o instanceof Short) {
                        extraSamples = (Short)o;
                    }
                    a = extraSamples == 1 ? "RGB Pre-A" : "RGBA";
                }
                return a;
            }
            case 3: {
                return "Palette";
            }
            case 5: {
                return "CMYK";
            }
            case 6: {
                return "YCbCr";
            }
            case 8: {
                return "CieLab";
            }
            case 32844: 
            case 32845: {
                return "LogLuv";
            }
        }
        return "Unknown";
    }

    String getIccProfileString(TiffDirectory directory) throws ImageReadException {
        byte[] b = directory.getFieldValue((TagInfoBytes)TiffEpTagConstants.EXIF_TAG_INTER_COLOR_PROFILE, false);
        if (b == null || b.length == 0) {
            return "N";
        }
        return "Y";
    }

    String getPlanarConfigurationString(TiffDirectory directory) throws ImageReadException {
        TiffPlanarConfiguration planarConfiguration;
        TiffField pcField = directory.findField((TagInfo)TiffTagConstants.TIFF_TAG_PLANAR_CONFIGURATION);
        TiffPlanarConfiguration tiffPlanarConfiguration = planarConfiguration = pcField == null ? TiffPlanarConfiguration.CHUNKY : TiffPlanarConfiguration.lenientValueOf((int)pcField.getIntValue());
        if (planarConfiguration == TiffPlanarConfiguration.CHUNKY) {
            return "Chunky";
        }
        return "Planar";
    }

    String formatHeader(int maxPathLen, boolean csv) {
        int n = maxPathLen;
        if (n < 10) {
            n = 10;
        }
        int k0 = (n - 4) / 2;
        int k1 = n - 4 - k0;
        String header = String.format("%" + k0 + "sPath%" + k1 + "s%s", "", "", "    Size     Layout  Blk_sz     P_conf  Compress  Predict  Data_Fmt   B/P B/S      Photo     ICC_Pro");
        if (csv) {
            return this.reformatHeaderForCsv(header);
        }
        return header;
    }

    void printLegend(PrintStream ps) {
        ps.println("Legend:");
        ps.println("  Size      Size of image (width-by-height)");
        ps.println("  Layout    Organization of the image file (strips versus tiles)");
        ps.println("  Blk_sz    Size of internal image blocks (strips versus tiles)");
        ps.println("  P_conf    Planar configuration, Chunky (interleaved samples) versus Planar ");
        ps.println("  Compress  Compression format");
        ps.println("  Predict   Predictor");
        ps.println("  Data_Fmt  Data format");
        ps.println("  B/P       Bits per pixel");
        ps.println("  B/S       Bits per sample");
        ps.println("  Photo     Photometric Interpretation (pixel color type)");
        ps.println("  ICC_Pro   Is ICC color profile supplied");
        ps.println("");
        ps.println("  RGBA       RGB with unassociated alpha (transparency)");
        ps.println("  RGBA_Pre-A RGB with associated (premultiplied) alpha");
        ps.println("");
    }

    private String reformatHeaderForCsv(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        boolean enableComma = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) {
                if (!enableComma) continue;
                enableComma = false;
                sb.append(',');
                continue;
            }
            enableComma = true;
            if (Character.isUpperCase(c)) {
                c = Character.toLowerCase(c);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private String trimForCsv(StringBuilder source) {
        int n = source.length();
        StringBuilder sb = new StringBuilder(n);
        boolean spaceEnabled = false;
        boolean spacePending = false;
        for (int i = 0; i < n; ++i) {
            char c = source.charAt(i);
            if (Character.isWhitespace(c)) {
                if (!spaceEnabled) continue;
                spacePending = true;
                spaceEnabled = false;
                continue;
            }
            if (Character.isLetter(c) || Character.isDigit(c)) {
                if (spacePending) {
                    sb.append(' ');
                    spacePending = false;
                }
                spaceEnabled = true;
            } else {
                spacePending = false;
                spaceEnabled = false;
            }
            sb.append(c);
        }
        n = sb.length();
        if (n > 0 && sb.charAt(n - 1) == ' ') {
            sb.setLength(n - 1);
        }
        return sb.toString();
    }
}

