/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.examples.tiff;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.examples.tiff.SurveyTiffFile;

public class SurveyTiffFolder {
    public static void main(String[] args) {
        File topLevelDir;
        if (args.length < 1) {
            System.err.println("Missing directory path");
            System.exit(-1);
        }
        if (!(topLevelDir = new File(args[0])).isDirectory() || !topLevelDir.canRead()) {
            System.err.println("Path specification is not an accessible directory " + args[0]);
            System.exit(-1);
        }
        String[] scratch = new String[256];
        ArrayList<String[]> pathList = new ArrayList<String[]>();
        SurveyTiffFolder.collectPaths(topLevelDir, pathList, scratch, 0);
        pathList.sort(new PathComparator());
        int[] maxLen = SurveyTiffFolder.findMaxLengths(pathList);
        if (args.length == 1) {
            SurveyTiffFolder.surveyFiles(topLevelDir, pathList, maxLen, false, System.out);
        } else {
            String ext;
            boolean csv = false;
            int i = args[1].lastIndexOf(46);
            if (i > 0 && ".csv".equalsIgnoreCase(ext = args[1].substring(i))) {
                csv = true;
            }
            File reportFile = new File(args[1]);
            try (FileOutputStream fos = new FileOutputStream(reportFile);
                 BufferedOutputStream bos = new BufferedOutputStream(fos);
                 PrintStream ps = new PrintStream((OutputStream)bos, true, "UTF-8");){
                SurveyTiffFolder.surveyFiles(topLevelDir, pathList, maxLen, csv, ps);
            }
            catch (IOException ioex) {
                System.err.println("IOException writing report to " + args[1]);
                System.err.println("" + ioex.getMessage());
            }
        }
    }

    private static int collectPaths(File parent, List<String[]> pathList, String[] scratch, int depth) {
        File[] files;
        if (depth == scratch.length) {
            return 0;
        }
        for (File f : files = parent.listFiles()) {
            String ext;
            String name;
            if (f.isHidden()) continue;
            scratch[depth] = name = f.getName();
            if (f.isDirectory()) {
                SurveyTiffFolder.collectPaths(f, pathList, scratch, depth + 1);
                continue;
            }
            int i = name.lastIndexOf(46);
            if (i <= 0 || !".tif".equals(ext = name.substring(i).toLowerCase()) && !".tiff".equals(ext)) continue;
            String[] temp = new String[depth + 1];
            System.arraycopy(scratch, 0, temp, 0, depth + 1);
            pathList.add(temp);
        }
        return depth;
    }

    private static int[] findMaxLengths(List<String[]> pathList) {
        int[] m = new int[1];
        for (String[] s : pathList) {
            if (s.length > m.length) {
                m = Arrays.copyOf(m, s.length);
            }
            for (int i = 0; i < s.length; ++i) {
                if (s[i].length() <= m[i]) continue;
                m[i] = s[i].length();
            }
        }
        return m;
    }

    private static void surveyFiles(File topDir, List<String[]> pathList, int[] maxLen, boolean csv, PrintStream ps) {
        SurveyTiffFile surveyor = new SurveyTiffFile();
        int n = maxLen.length - 1;
        for (int element : maxLen) {
            n += element;
        }
        if (n < 10) {
            n = 10;
        }
        String header = surveyor.formatHeader(n, csv);
        ps.println(header);
        ArrayList<String> badFiles = new ArrayList<String>();
        for (String[] path : pathList) {
            String result;
            int i;
            StringBuilder sBuilder = new StringBuilder();
            File file = topDir;
            for (String s : path) {
                file = new File(file, s);
            }
            for (i = 0; i < path.length; ++i) {
                if (i > 0) {
                    sBuilder.append('/');
                }
                sBuilder.append(path[i]);
            }
            if (!csv) {
                for (i = sBuilder.length(); i < n; ++i) {
                    sBuilder.append(' ');
                }
            }
            try {
                result = surveyor.surveyFile(file, csv);
            }
            catch (IOException | ImageReadException ex) {
                sBuilder.append(ex.getMessage());
                badFiles.add(sBuilder.toString());
                continue;
            }
            sBuilder.append(result);
            ps.println(sBuilder.toString());
        }
        if (!csv && !badFiles.isEmpty()) {
            ps.println();
            ps.println("Bad Files:");
            for (String s : badFiles) {
                ps.println(s);
            }
        }
        if (!csv) {
            ps.println();
            surveyor.printLegend(ps);
        }
    }

    private static class PathComparator
    implements Comparator<String[]> {
        private PathComparator() {
        }

        @Override
        public int compare(String[] a, String[] b) {
            for (int i = 0; i < a.length && i < b.length; ++i) {
                int test;
                if (this.isNumeric(a[i]) && this.isNumeric(b[i])) {
                    int iA = Integer.parseInt(a[i]);
                    int iB = Integer.parseInt(b[i]);
                    test = iA - iB;
                } else {
                    test = a[i].compareTo(b[i]);
                }
                if (test == 0) continue;
                return test;
            }
            if (a.length < b.length) {
                return -1;
            }
            return 1;
        }

        private boolean isNumeric(String a) {
            for (int i = 0; i < a.length(); ++i) {
                if (Character.isDigit(a.charAt(i))) continue;
                return false;
            }
            return true;
        }
    }
}

