/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.bmp;

import java.io.File;
import java.io.IOException;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.ImagingParameters;
import org.apache.commons.imaging.formats.bmp.BmpImageParser;
import org.apache.commons.imaging.formats.bmp.BmpImagingParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BmpImageParserTest {
    @Test
    public void testImageWidthRounding() throws ImageReadException, IOException {
        String file = "/images/bmp/IMAGING-264/test-72_6-dpi.bmp";
        File bmp = new File(BmpImageParser.class.getResource("/images/bmp/IMAGING-264/test-72_6-dpi.bmp").getFile());
        BmpImageParser parser = new BmpImageParser();
        ImageInfo imageInfo = parser.getImageInfo(bmp, (ImagingParameters)new BmpImagingParameters());
        Assertions.assertEquals((int)73, (int)imageInfo.getPhysicalWidthDpi(), (String)"Expected 72.6 resolution to be rounded to 73");
    }

    @Test
    public void testImageForNegativeArraySizeException() throws ImageReadException, IOException {
        String file = "/images/bmp/IMAGING-279/negative_array_size_exception.bmp";
        File bmp = new File(BmpImageParser.class.getResource("/images/bmp/IMAGING-279/negative_array_size_exception.bmp").getFile());
        BmpImageParser parser = new BmpImageParser();
        Assertions.assertThrows(IOException.class, () -> parser.getImageInfo(bmp, (ImagingParameters)new BmpImagingParameters()));
    }
}

