/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.bmp;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingTestConstants;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.common.bytesource.ByteSourceFile;
import org.apache.commons.imaging.formats.bmp.BmpBaseTest;
import org.apache.commons.imaging.formats.bmp.BmpImageParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class BmpReadTest
extends BmpBaseTest {
    public static Collection<File> data() throws Exception {
        return BmpReadTest.getBmpImages();
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testImageInfo(File imageFile) throws ImageReadException, IOException {
        ImageInfo imageInfo = Imaging.getImageInfo((File)imageFile);
        Assertions.assertNotNull((Object)imageInfo);
    }

    @Disabled(value="RoundtripTest has to be fixed before implementation can throw UnsupportedOperationException")
    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testMetaData(File imageFile) {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> Imaging.getMetadata((File)imageFile));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testBufferedImage(File imageFile) throws Exception {
        BufferedImage image = Imaging.getBufferedImage((File)imageFile);
        Assertions.assertNotNull((Object)image);
    }

    @Test
    public void testGetMaskShiftZeroMask() throws ImageReadException, IOException {
        File inputFile = new File(ImagingTestConstants.TEST_IMAGE_FOLDER + "/bmp/5/@broken/timeout-bd15dbfa26b4e88070de540c6603039e8a88626f");
        new BmpImageParser().dumpImageFile((ByteSource)new ByteSourceFile(inputFile));
    }

    @Test
    public void testNegativePaletteLength() throws ImageReadException, IOException {
        String input = "/images/bmp/IMAGING-325/crash-3afb569de74522535ef65922233e1920455cdc14.bmp";
        String location = BmpReadTest.class.getResource("/images/bmp/IMAGING-325/crash-3afb569de74522535ef65922233e1920455cdc14.bmp").getFile();
        File inputFile = new File(location);
        Assertions.assertThrows(ImageReadException.class, () -> new BmpImageParser().dumpImageFile((ByteSource)new ByteSourceFile(inputFile)));
    }
}

