/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.bmp;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.formats.bmp.BmpBaseTest;
import org.apache.commons.imaging.internal.Debug;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BmpRoundtripTest
extends BmpBaseTest {
    private int[][] getSimpleRawData(int width, int height, int value) {
        int[][] result = new int[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y][x] = value;
            }
        }
        return result;
    }

    private int[][] getAscendingRawData(int width, int height) {
        int[][] result = new int[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int argb;
                int alpha = (x + y) % 256;
                int value = (x + y) % 256;
                result[y][x] = argb = (0xFF & alpha) << 24 | (0xFF & value) << 16 | (0xFF & value) << 8 | (0xFF & value) << 0;
            }
        }
        return result;
    }

    private int[][] randomRawData(int width, int height) {
        Random random = new Random();
        int[][] result = new int[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int argb;
                result[y][x] = argb = random.nextInt();
            }
        }
        return result;
    }

    @Test
    public void testSmallBlackPixels() throws Exception {
        int[][] smallBlackPixels = this.getSimpleRawData(256, 256, 0);
        this.writeAndReadImageData(smallBlackPixels);
    }

    @Test
    public void testSingleBlackPixel() throws Exception {
        int[][] singleBlackPixel = this.getSimpleRawData(1, 1, 0);
        this.writeAndReadImageData(singleBlackPixel);
    }

    @Test
    public void testSmallRedPixels() throws Exception {
        int[][] smallRedPixels = this.getSimpleRawData(256, 256, -65536);
        this.writeAndReadImageData(smallRedPixels);
    }

    @Test
    public void testSingleRedPixel() throws Exception {
        int[][] singleRedPixel = this.getSimpleRawData(1, 1, -65536);
        this.writeAndReadImageData(singleRedPixel);
    }

    @Test
    public void testSmallAscendingPixels() throws Exception {
        int[][] smallAscendingPixels = this.getAscendingRawData(256, 256);
        this.writeAndReadImageData(smallAscendingPixels);
    }

    @Test
    public void testSmallRandomPixels() throws Exception {
        int[][] smallRandomPixels = this.randomRawData(256, 256);
        this.writeAndReadImageData(smallRandomPixels);
    }

    private BufferedImage imageDataToBufferedImage(int[][] rawData) {
        int width = rawData[0].length;
        int height = rawData.length;
        BufferedImage image = new BufferedImage(width, height, 2);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                image.setRGB(x, y, rawData[y][x]);
            }
        }
        return image;
    }

    private int[][] bufferedImageToImageData(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[][] result = new int[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y][x] = image.getRGB(x, y);
            }
        }
        return result;
    }

    private void writeAndReadImageData(int[][] rawData) throws IOException, ImageReadException, ImageWriteException {
        BufferedImage srcImage = this.imageDataToBufferedImage(rawData);
        byte[] bytes = Imaging.writeImageToBytes((BufferedImage)srcImage, (ImageFormat)ImageFormats.BMP);
        File tempFile = File.createTempFile("temp", ".bmp");
        FileUtils.writeByteArrayToFile((File)tempFile, (byte[])bytes);
        BufferedImage dstImage = Imaging.getBufferedImage((byte[])bytes);
        Assertions.assertNotNull((Object)dstImage);
        Assertions.assertEquals((int)srcImage.getWidth(), (int)dstImage.getWidth());
        Assertions.assertEquals((int)srcImage.getHeight(), (int)dstImage.getHeight());
        int[][] dstData = this.bufferedImageToImageData(dstImage);
        this.compare(rawData, dstData);
    }

    private void compare(int[][] a, int[][] b) {
        Assertions.assertNotNull((Object)a);
        Assertions.assertNotNull((Object)b);
        Assertions.assertEquals((int)a.length, (int)b.length);
        for (int y = 0; y < a.length; ++y) {
            Assertions.assertEquals((int)a[y].length, (int)b[y].length);
            Assertions.assertEquals((int)a[0].length, (int)b[y].length);
            for (int x = 0; x < a[y].length; ++x) {
                int rgbA = 0xFFFFFF & a[y][x];
                int rgbB = 0xFFFFFF & b[y][x];
                if (rgbA != rgbB) {
                    Debug.debug((String)("x: " + x + ", y: " + y + ", rgbA: " + rgbA + " (0x" + Integer.toHexString(rgbA) + "), rgbB: " + rgbB + " (0x" + Integer.toHexString(rgbB) + ")"));
                }
                Assertions.assertEquals((int)rgbA, (int)rgbB);
            }
        }
    }
}

