/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.gif;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingTest;

public abstract class GifBaseTest
extends ImagingTest {
    private static final String ANIMATED_FOLDER_NAME = "animated";
    private static final String SINGLE_IMAGE_FOLDER_NAME = "single";
    private static final ImagingTest.ImageFilter IMAGE_FILTER = GifBaseTest::isGif;
    private static final ImagingTest.ImageFilter ANIMATED_IMAGE_FILTER = file -> GifBaseTest.isGif(file) && GifBaseTest.isAnimated(file);
    private static final ImagingTest.ImageFilter SINGLE_IMAGE_FILTER = file -> GifBaseTest.isGif(file) && GifBaseTest.isSingleImage(file);

    private static boolean isGif(File file) throws IOException, ImageReadException {
        ImageFormat format = Imaging.guessFormat((File)file);
        return format == ImageFormats.GIF;
    }

    private static boolean isAnimated(File file) {
        File index = file.getParentFile();
        File type = index.getParentFile();
        return type.getName().equals(ANIMATED_FOLDER_NAME);
    }

    private static boolean isSingleImage(File file) {
        File index = file.getParentFile();
        File type = index.getParentFile();
        return type.getName().equals(SINGLE_IMAGE_FOLDER_NAME);
    }

    protected static List<File> getGifImages() throws IOException, ImageReadException {
        return GifBaseTest.getTestImages(IMAGE_FILTER);
    }

    protected static List<File> getAnimatedGifImages() throws IOException, ImageReadException {
        return GifBaseTest.getTestImages(ANIMATED_IMAGE_FILTER);
    }

    protected static List<File> getGifImagesWithSingleImage() throws IOException, ImageReadException {
        return GifBaseTest.getTestImages(SINGLE_IMAGE_FILTER);
    }
}

