/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.icns;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.formats.icns.IcnsBaseTest;
import org.apache.commons.imaging.formats.icns.IcnsImageParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class IcnsReadTest
extends IcnsBaseTest {
    public static Stream<File> data() throws Exception {
        return IcnsReadTest.getIcnsImages().stream();
    }

    public static Stream<Arguments> provideIcnsImagesWithMonoAndJpegPngData() {
        return Arrays.asList(Arguments.of((Object[])new Object[]{"/images/icns/IMAGING-248/python.icns", 7}), Arguments.of((Object[])new Object[]{"/images/icns/IMAGING-248/groovy.icns", 3})).stream();
    }

    @Disabled(value="RoundtripTest has to be fixed befor implementation can throw UnsupportedOperationException")
    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testImageMetadata(File imageFile) {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> Imaging.getMetadata((File)imageFile));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testImageInfo(File imageFile) throws Exception {
        ImageInfo imageInfo = Imaging.getImageInfo((File)imageFile);
        Assertions.assertNotNull((Object)imageInfo);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testBufferedImage(File imageFile) throws Exception {
        BufferedImage image = Imaging.getBufferedImage((File)imageFile);
        Assertions.assertNotNull((Object)image);
    }

    @ParameterizedTest
    @MethodSource(value={"provideIcnsImagesWithMonoAndJpegPngData"})
    public void testIcnsElementMonoPngJpeg(String file, int numberOfImages) throws ImageReadException, IOException {
        File testFile = new File(IcnsReadTest.class.getResource(file).getFile());
        List images = new IcnsImageParser().getAllBufferedImages(testFile);
        Assertions.assertEquals((int)numberOfImages, (int)images.size());
    }
}

