/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.ico;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.BinaryOutputStream;
import org.apache.commons.imaging.formats.ico.IcoBaseTest;
import org.apache.commons.imaging.internal.Debug;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IcoRoundtripTest
extends IcoBaseTest {
    private static final int[][] IMAGE = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0}, {0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0}, {0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0}, {0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0}, {0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0}, {0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0}, {0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
    private final Map<Integer, BitmapGenerator> generatorMap = new HashMap<Integer, BitmapGenerator>();

    public IcoRoundtripTest() {
        this.generatorMap.put(1, new GeneratorFor1BitBitmaps());
        this.generatorMap.put(4, new GeneratorFor4BitBitmaps());
        this.generatorMap.put(8, new GeneratorFor8BitBitmaps());
        this.generatorMap.put(16, new GeneratorFor16BitBitmaps());
        this.generatorMap.put(24, new GeneratorFor24BitBitmaps());
        this.generatorMap.put(32, new GeneratorFor32BitBitmaps());
    }

    private void writeICONDIR(BinaryOutputStream bos, int reserved, int type, int count) throws IOException {
        bos.write2Bytes(reserved);
        bos.write2Bytes(type);
        bos.write2Bytes(count);
    }

    private void writeICONDIRENTRY(BinaryOutputStream bos, int width, int height, int colorCount, int reserved, int planes, int bitCount, int bytesInRes) throws IOException {
        bos.write(width);
        bos.write(height);
        bos.write(colorCount);
        bos.write(reserved);
        bos.write2Bytes(planes);
        bos.write2Bytes(bitCount);
        bos.write4Bytes(bytesInRes);
        bos.write4Bytes(22);
    }

    private void writeBITMAPINFOHEADER(BinaryOutputStream bos, int width, int height, int colorPlanes, int bitCount, int compression, int colorsUsed, int colorsImportant) throws IOException {
        bos.write4Bytes(40);
        bos.write4Bytes(width);
        bos.write4Bytes(height);
        bos.write2Bytes(colorPlanes);
        bos.write2Bytes(bitCount);
        bos.write4Bytes(compression);
        bos.write4Bytes(0);
        bos.write4Bytes(0);
        bos.write4Bytes(0);
        bos.write4Bytes(colorsUsed);
        bos.write4Bytes(colorsImportant);
    }

    @Test
    public void testNormalIcons() throws Exception {
        int foreground = -1048352;
        int background = -15720400;
        for (Map.Entry<Integer, BitmapGenerator> entry : this.generatorMap.entrySet()) {
            int bitDepth = entry.getKey();
            BitmapGenerator bitmapGenerator = entry.getValue();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BinaryOutputStream bos = new BinaryOutputStream((OutputStream)baos, ByteOrder.LITTLE_ENDIAN);
            byte[] bitmap = bitmapGenerator.generateBitmap(-1048352, -15720400, bitDepth <= 8 ? 1 << bitDepth : 0);
            this.writeICONDIR(bos, 0, 1, 1);
            this.writeICONDIRENTRY(bos, 16, 16, 0, 0, 1, bitDepth, 40 + bitmap.length);
            this.writeBITMAPINFOHEADER(bos, 16, 32, 1, bitDepth, 0, 0, 0);
            bos.write(bitmap);
            bos.flush();
            this.writeAndReadImageData("16x16x" + bitDepth, baos.toByteArray(), -1048352, -15720400);
        }
    }

    @Test
    public void testBadICONDIRENTRYIcons() throws Exception {
        int foreground = -1048352;
        int background = -15720400;
        for (Map.Entry<Integer, BitmapGenerator> entry : this.generatorMap.entrySet()) {
            int bitDepth = entry.getKey();
            BitmapGenerator bitmapGenerator = entry.getValue();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BinaryOutputStream bos = new BinaryOutputStream((OutputStream)baos, ByteOrder.LITTLE_ENDIAN);
            byte[] bitmap = bitmapGenerator.generateBitmap(-1048352, -15720400, bitDepth <= 8 ? 1 << bitDepth : 0);
            this.writeICONDIR(bos, 0, 1, 1);
            this.writeICONDIRENTRY(bos, 3, 4, 7, 20, 11, 19, 40 + bitmap.length);
            this.writeBITMAPINFOHEADER(bos, 16, 32, 1, bitDepth, 0, 0, 0);
            bos.write(bitmap);
            bos.flush();
            this.writeAndReadImageData("16x16x" + bitDepth + "-corrupt-icondirentry", baos.toByteArray(), -1048352, -15720400);
        }
    }

    @Test
    public void testColorsUsed() throws Exception {
        int foreground = -1048352;
        int background = -15720400;
        for (Map.Entry<Integer, BitmapGenerator> entry : this.generatorMap.entrySet()) {
            int bitDepth = entry.getKey();
            BitmapGenerator bitmapGenerator = entry.getValue();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BinaryOutputStream bos = new BinaryOutputStream((OutputStream)baos, ByteOrder.LITTLE_ENDIAN);
            byte[] bitmap = bitmapGenerator.generateBitmap(-1048352, -15720400, 2);
            this.writeICONDIR(bos, 0, 1, 1);
            this.writeICONDIRENTRY(bos, 3, 4, 7, 20, 11, 19, 40 + bitmap.length);
            this.writeBITMAPINFOHEADER(bos, 16, 32, 1, bitDepth, 0, 2, 0);
            bos.write(bitmap);
            bos.flush();
            this.writeAndReadImageData("16x16x" + bitDepth + "-custom-palette", baos.toByteArray(), -1048352, -15720400);
        }
    }

    @Test
    public void testZeroColorPlanes() throws Exception {
        int foreground = -1048352;
        int background = -15720400;
        for (Map.Entry<Integer, BitmapGenerator> entry : this.generatorMap.entrySet()) {
            int bitDepth = entry.getKey();
            BitmapGenerator bitmapGenerator = entry.getValue();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BinaryOutputStream bos = new BinaryOutputStream((OutputStream)baos, ByteOrder.LITTLE_ENDIAN);
            byte[] bitmap = bitmapGenerator.generateBitmap(-1048352, -15720400, bitDepth <= 8 ? 1 << bitDepth : 0);
            this.writeICONDIR(bos, 0, 1, 1);
            this.writeICONDIRENTRY(bos, 16, 16, 0, 0, 1, bitDepth, 40 + bitmap.length);
            this.writeBITMAPINFOHEADER(bos, 16, 32, 0, bitDepth, 0, 0, 0);
            bos.write(bitmap);
            bos.flush();
            boolean threw = false;
            try {
                this.writeAndReadImageData("16x16x" + bitDepth + "-zero-colorPlanes", baos.toByteArray(), -1048352, -15720400);
            }
            catch (ImageReadException imageReadException) {
                threw = true;
            }
            Assertions.assertTrue((boolean)threw);
        }
    }

    @Test
    public void testBitfieldCompression() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputStream bos = new BinaryOutputStream((OutputStream)baos, ByteOrder.LITTLE_ENDIAN);
        byte[] bitmap = new GeneratorFor32BitBitmaps().generate32bitRGBABitmap(-65536, -1, 0, true);
        this.writeICONDIR(bos, 0, 1, 1);
        this.writeICONDIRENTRY(bos, 16, 16, 0, 0, 1, 32, 40 + bitmap.length);
        this.writeBITMAPINFOHEADER(bos, 16, 32, 1, 32, 3, 0, 0);
        bos.write4Bytes(255);
        bos.write4Bytes(65280);
        bos.write4Bytes(0xFF0000);
        bos.write(bitmap);
        bos.flush();
        this.writeAndReadImageData("16x16x32-bitfield-compressed", baos.toByteArray(), -16776961, -1);
    }

    @Test
    public void test32bitMask() throws Exception {
        int foreground = -1048352;
        int background = -15720400;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputStream bos = new BinaryOutputStream((OutputStream)baos, ByteOrder.LITTLE_ENDIAN);
        byte[] bitmap = new GeneratorFor32BitBitmaps().generate32bitRGBABitmap(-1048352, -15720400, 0, false);
        this.writeICONDIR(bos, 0, 1, 1);
        this.writeICONDIRENTRY(bos, 16, 16, 0, 0, 1, 32, 40 + bitmap.length);
        this.writeBITMAPINFOHEADER(bos, 16, 32, 1, 32, 0, 0, 0);
        bos.write(bitmap);
        bos.flush();
        this.writeAndReadImageData("16x16x32-no-mask", baos.toByteArray(), -1048352, -15720400);
    }

    @Test
    public void testAlphaVersusANDMask() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputStream bos = new BinaryOutputStream((OutputStream)baos, ByteOrder.LITTLE_ENDIAN);
        byte[] bitmap = new GeneratorFor32BitBitmaps().generate32bitRGBABitmap(-16777216, 0, 0, true);
        this.writeICONDIR(bos, 0, 1, 1);
        this.writeICONDIRENTRY(bos, 16, 16, 0, 0, 1, 32, 40 + bitmap.length);
        this.writeBITMAPINFOHEADER(bos, 16, 32, 1, 32, 0, 0, 0);
        bos.write(bitmap);
        bos.flush();
        this.writeAndReadImageData("16x16x32-alpha-vs-mask", baos.toByteArray(), -16777216, 0);
    }

    @Test
    public void testFullyTransparent32bitRGBA() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputStream bos = new BinaryOutputStream((OutputStream)baos, ByteOrder.LITTLE_ENDIAN);
        byte[] bitmap = new GeneratorFor32BitBitmaps().generate32bitRGBABitmap(0, 0xFFFFFF, 0, true);
        this.writeICONDIR(bos, 0, 1, 1);
        this.writeICONDIRENTRY(bos, 16, 16, 0, 0, 1, 32, 40 + bitmap.length);
        this.writeBITMAPINFOHEADER(bos, 16, 32, 1, 32, 0, 0, 0);
        bos.write(bitmap);
        bos.flush();
        this.writeAndReadImageData("16x16x32-fully-transparent", baos.toByteArray(), -16777216, -1);
    }

    private void writeAndReadImageData(String description, byte[] rawData, int foreground, int background) throws IOException, ImageReadException {
        File tempFile = File.createTempFile("temp", ".ico");
        FileUtils.writeByteArrayToFile((File)tempFile, (byte[])rawData);
        BufferedImage dstImage = Imaging.getBufferedImage((File)tempFile);
        Assertions.assertNotNull((Object)dstImage);
        Assertions.assertEquals((int)dstImage.getWidth(), (int)IMAGE[0].length);
        Assertions.assertEquals((int)dstImage.getHeight(), (int)IMAGE.length);
        this.verify(dstImage, foreground, background);
    }

    private void verify(BufferedImage data, int foreground, int background) {
        Assertions.assertNotNull((Object)data);
        Assertions.assertEquals((int)data.getHeight(), (int)IMAGE.length);
        for (int y = 0; y < data.getHeight(); ++y) {
            Assertions.assertEquals((int)data.getWidth(), (int)IMAGE[y].length);
            for (int x = 0; x < data.getWidth(); ++x) {
                int dataARGB;
                int imageARGB = IMAGE[y][x] == 1 ? foreground : background;
                if (imageARGB != (dataARGB = data.getRGB(x, y))) {
                    Debug.debug((String)("x: " + x + ", y: " + y + ", image: " + imageARGB + " (0x" + Integer.toHexString(imageARGB) + "), data: " + dataARGB + " (0x" + Integer.toHexString(dataARGB) + ")"));
                }
                Assertions.assertEquals((int)imageARGB, (int)dataARGB);
            }
        }
    }

    private static class GeneratorFor32BitBitmaps
    implements BitmapGenerator {
        private GeneratorFor32BitBitmaps() {
        }

        @Override
        public byte[] generateBitmap(int foreground, int background, int paletteSize) throws IOException, ImageWriteException {
            return this.generate32bitRGBABitmap(foreground, background, paletteSize, true);
        }

        public byte[] generate32bitRGBABitmap(int foreground, int background, int paletteSize, boolean writeMask) throws IOException {
            try (ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();){
                byte[] byArray;
                try (BinaryOutputStream bos = new BinaryOutputStream((OutputStream)byteArrayStream, ByteOrder.LITTLE_ENDIAN);){
                    int y;
                    for (int i = 0; i < paletteSize; ++i) {
                        bos.write4Bytes(0);
                    }
                    for (y = 15; y >= 0; --y) {
                        for (int x = 0; x < 16; ++x) {
                            if (IMAGE[y][x] == 1) {
                                bos.write4Bytes(foreground);
                                continue;
                            }
                            bos.write4Bytes(background);
                        }
                    }
                    if (writeMask) {
                        for (y = IMAGE.length - 1; y >= 0; --y) {
                            bos.write(0);
                            bos.write(0);
                            bos.write(0);
                            bos.write(0);
                        }
                    }
                    bos.flush();
                    byArray = byteArrayStream.toByteArray();
                }
                return byArray;
            }
        }
    }

    private static class GeneratorFor24BitBitmaps
    implements BitmapGenerator {
        private GeneratorFor24BitBitmaps() {
        }

        @Override
        public byte[] generateBitmap(int foreground, int background, int paletteSize) throws IOException, ImageWriteException {
            try (ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();){
                byte[] byArray;
                try (BinaryOutputStream bos = new BinaryOutputStream((OutputStream)byteArrayStream, ByteOrder.LITTLE_ENDIAN);){
                    int y;
                    for (int i = 0; i < paletteSize; ++i) {
                        bos.write4Bytes(0);
                    }
                    for (y = 15; y >= 0; --y) {
                        for (int x = 0; x < 16; ++x) {
                            if (IMAGE[y][x] == 1) {
                                bos.write3Bytes(0xFFFFFF & foreground);
                                continue;
                            }
                            bos.write3Bytes(0xFFFFFF & background);
                        }
                    }
                    for (y = IMAGE.length - 1; y >= 0; --y) {
                        bos.write(0);
                        bos.write(0);
                        bos.write(0);
                        bos.write(0);
                    }
                    bos.flush();
                    byArray = byteArrayStream.toByteArray();
                }
                return byArray;
            }
        }
    }

    private static class GeneratorFor16BitBitmaps
    implements BitmapGenerator {
        private GeneratorFor16BitBitmaps() {
        }

        @Override
        public byte[] generateBitmap(int foreground, int background, int paletteSize) throws IOException, ImageWriteException {
            try (ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();){
                byte[] byArray;
                try (BinaryOutputStream bos = new BinaryOutputStream((OutputStream)byteArrayStream, ByteOrder.LITTLE_ENDIAN);){
                    int y;
                    for (int i = 0; i < paletteSize; ++i) {
                        bos.write4Bytes(0);
                    }
                    for (y = 15; y >= 0; --y) {
                        for (int x = 0; x < 16; ++x) {
                            if (IMAGE[y][x] == 1) {
                                bos.write2Bytes(0x1F & foreground >> 3 | (0x1F & foreground >> 11) << 5 | (0x1F & foreground >> 19) << 10);
                                continue;
                            }
                            bos.write2Bytes(0x1F & background >> 3 | (0x1F & background >> 11) << 5 | (0x1F & background >> 19) << 10);
                        }
                    }
                    for (y = IMAGE.length - 1; y >= 0; --y) {
                        bos.write(0);
                        bos.write(0);
                        bos.write(0);
                        bos.write(0);
                    }
                    bos.flush();
                    byArray = byteArrayStream.toByteArray();
                }
                return byArray;
            }
        }
    }

    private static class GeneratorFor8BitBitmaps
    implements BitmapGenerator {
        private GeneratorFor8BitBitmaps() {
        }

        @Override
        public byte[] generateBitmap(int foreground, int background, int paletteSize) throws IOException, ImageWriteException {
            try (ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();){
                byte[] byArray;
                try (BinaryOutputStream bos = new BinaryOutputStream((OutputStream)byteArrayStream, ByteOrder.LITTLE_ENDIAN);){
                    int y;
                    bos.write3Bytes(background);
                    bos.write(0);
                    bos.write3Bytes(foreground);
                    bos.write(0);
                    for (int i = 2; i < paletteSize; ++i) {
                        bos.write4Bytes(0);
                    }
                    for (y = 15; y >= 0; --y) {
                        for (int x = 0; x < 16; ++x) {
                            bos.write(IMAGE[y][x]);
                        }
                    }
                    for (y = IMAGE.length - 1; y >= 0; --y) {
                        bos.write(0);
                        bos.write(0);
                        bos.write(0);
                        bos.write(0);
                    }
                    bos.flush();
                    byArray = byteArrayStream.toByteArray();
                }
                return byArray;
            }
        }
    }

    private static class GeneratorFor4BitBitmaps
    implements BitmapGenerator {
        private GeneratorFor4BitBitmaps() {
        }

        @Override
        public byte[] generateBitmap(int foreground, int background, int paletteSize) throws IOException, ImageWriteException {
            try (ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();){
                byte[] byArray;
                try (BinaryOutputStream bos = new BinaryOutputStream((OutputStream)byteArrayStream, ByteOrder.LITTLE_ENDIAN);){
                    int y;
                    bos.write3Bytes(background);
                    bos.write(0);
                    bos.write3Bytes(foreground);
                    bos.write(0);
                    for (int i = 2; i < paletteSize; ++i) {
                        bos.write4Bytes(0);
                    }
                    for (y = 15; y >= 0; --y) {
                        for (int x = 0; x < 16; x += 2) {
                            bos.write((0xF & IMAGE[y][x]) << 4 | 0xF & IMAGE[y][x + 1]);
                        }
                    }
                    for (y = IMAGE.length - 1; y >= 0; --y) {
                        bos.write(0);
                        bos.write(0);
                        bos.write(0);
                        bos.write(0);
                    }
                    bos.flush();
                    byArray = byteArrayStream.toByteArray();
                }
                return byArray;
            }
        }
    }

    private static class GeneratorFor1BitBitmaps
    implements BitmapGenerator {
        private GeneratorFor1BitBitmaps() {
        }

        @Override
        public byte[] generateBitmap(int foreground, int background, int paletteSize) throws IOException, ImageWriteException {
            try (ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();){
                byte[] byArray;
                try (BinaryOutputStream bos = new BinaryOutputStream((OutputStream)byteArrayStream, ByteOrder.LITTLE_ENDIAN);){
                    int y;
                    bos.write3Bytes(background);
                    bos.write(0);
                    bos.write3Bytes(foreground);
                    bos.write(0);
                    for (int i = 2; i < paletteSize; ++i) {
                        bos.write4Bytes(0);
                    }
                    for (y = 15; y >= 0; --y) {
                        for (int x = 0; x < 16; x += 8) {
                            bos.write((1 & IMAGE[y][x]) << 7 | (1 & IMAGE[y][x + 1]) << 6 | (1 & IMAGE[y][x + 2]) << 5 | (1 & IMAGE[y][x + 3]) << 4 | (1 & IMAGE[y][x + 4]) << 3 | (1 & IMAGE[y][x + 5]) << 2 | (1 & IMAGE[y][x + 6]) << 1 | (1 & IMAGE[y][x + 7]) << 0);
                        }
                        bos.write(0);
                        bos.write(0);
                    }
                    for (y = IMAGE.length - 1; y >= 0; --y) {
                        bos.write(0);
                        bos.write(0);
                        bos.write(0);
                        bos.write(0);
                    }
                    bos.flush();
                    byArray = byteArrayStream.toByteArray();
                }
                return byArray;
            }
        }
    }

    private static interface BitmapGenerator {
        public byte[] generateBitmap(int var1, int var2, int var3) throws IOException, ImageWriteException;
    }
}

