/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.decoder;

import org.apache.commons.imaging.formats.jpeg.decoder.Dct;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DctTest {
    @Test
    public void testVectors() {
        int i;
        float[] originalData = new float[8];
        for (int i2 = 0; i2 < 8; ++i2) {
            originalData[i2] = i2;
        }
        float[] transformed = DctTest.REFERENCE_forwardDCT(originalData);
        float[] reversed = DctTest.REFERENCE_inverseDCT(transformed);
        for (int i3 = 0; i3 < 8; ++i3) {
            Assertions.assertEquals((double)originalData[i3], (double)reversed[i3], (double)0.001);
        }
        float[] data = (float[])originalData.clone();
        Dct.forwardDCT8((float[])data);
        Dct.scaleQuantizationVector((float[])data);
        for (i = 0; i < 8; ++i) {
            Assertions.assertEquals((double)data[i], (double)transformed[i], (double)0.001);
        }
        Dct.scaleDequantizationVector((float[])data);
        Dct.inverseDCT8((float[])data);
        for (i = 0; i < 8; ++i) {
            Assertions.assertEquals((double)data[i], (double)originalData[i], (double)0.001);
        }
    }

    @Test
    public void testMatrices() {
        int x;
        int y;
        float[] originalData = new float[64];
        float[][] originalData8x8 = new float[8][8];
        for (int y2 = 0; y2 < 8; ++y2) {
            for (int x2 = 0; x2 < 8; ++x2) {
                float value;
                originalData8x8[y2][x2] = value = (float)(8 * y2 + x2);
                originalData[8 * y2 + x2] = value;
            }
        }
        float[][] transformed8x8 = DctTest.REFERENCE_forwardDCT(originalData8x8);
        float[][] reversed8x8 = DctTest.REFERENCE_inverseDCT(transformed8x8);
        for (int y3 = 0; y3 < 8; ++y3) {
            for (int x3 = 0; x3 < 8; ++x3) {
                Assertions.assertEquals((double)originalData8x8[y3][x3], (double)reversed8x8[y3][x3], (double)0.001);
            }
        }
        float[] data = (float[])originalData.clone();
        Dct.forwardDCT8x8((float[])data);
        Dct.scaleQuantizationMatrix((float[])data);
        for (y = 0; y < 8; ++y) {
            for (x = 0; x < 8; ++x) {
                Assertions.assertEquals((double)transformed8x8[y][x], (double)data[8 * y + x], (double)0.001);
            }
        }
        Dct.scaleDequantizationMatrix((float[])data);
        Dct.inverseDCT8x8((float[])data);
        for (y = 0; y < 8; ++y) {
            for (x = 0; x < 8; ++x) {
                Assertions.assertEquals((double)originalData8x8[y][x], (double)data[8 * y + x], (double)0.001);
            }
        }
    }

    private static float[][] REFERENCE_inverseDCT(float[][] matrix) {
        float[][] ret = new float[8][8];
        for (int y = 0; y < 8; ++y) {
            for (int x = 0; x < 8; ++x) {
                float sum = 0.0f;
                for (int u = 0; u < 8; ++u) {
                    for (int v = 0; v < 8; ++v) {
                        float cu = u == 0 ? (float)(1.0 / Math.sqrt(2.0)) : 1.0f;
                        float cv = v == 0 ? (float)(1.0 / Math.sqrt(2.0)) : 1.0f;
                        sum = (float)((double)sum + (double)(cu * cv * matrix[v][u]) * Math.cos((double)((2 * x + 1) * u) * Math.PI / 16.0) * Math.cos((double)((2 * y + 1) * v) * Math.PI / 16.0));
                    }
                }
                ret[y][x] = 0.25f * sum;
            }
        }
        return ret;
    }

    private static float[] REFERENCE_inverseDCT(float[] vector) {
        float[] ret = new float[8];
        for (int x = 0; x < 8; ++x) {
            float sum = 0.0f;
            for (int u = 0; u < 8; ++u) {
                float cu = u == 0 ? (float)(1.0 / Math.sqrt(2.0)) : 1.0f;
                sum = (float)((double)sum + (double)(cu * vector[u]) * Math.cos((double)((2 * x + 1) * u) * Math.PI / 16.0));
            }
            ret[x] = 0.5f * sum;
        }
        return ret;
    }

    private static float[][] REFERENCE_forwardDCT(float[][] matrix) {
        float[][] ret = new float[8][8];
        for (int u = 0; u < 8; ++u) {
            for (int v = 0; v < 8; ++v) {
                float sum = 0.0f;
                float cu = u == 0 ? (float)(1.0 / Math.sqrt(2.0)) : 1.0f;
                float cv = v == 0 ? (float)(1.0 / Math.sqrt(2.0)) : 1.0f;
                for (int x = 0; x < 8; ++x) {
                    for (int y = 0; y < 8; ++y) {
                        sum = (float)((double)sum + (double)matrix[y][x] * Math.cos((double)((2 * x + 1) * u) * Math.PI / 16.0) * Math.cos((double)((2 * y + 1) * v) * Math.PI / 16.0));
                    }
                }
                ret[v][u] = 0.25f * cu * cv * sum;
            }
        }
        return ret;
    }

    private static float[] REFERENCE_forwardDCT(float[] vector) {
        float[] ret = new float[8];
        for (int u = 0; u < 8; ++u) {
            float sum = 0.0f;
            float cu = u == 0 ? (float)(1.0 / Math.sqrt(2.0)) : 1.0f;
            for (int x = 0; x < 8; ++x) {
                sum = (float)((double)sum + (double)vector[x] * Math.cos((double)((2 * x + 1) * u) * Math.PI / 16.0));
            }
            ret[u] = 0.5f * cu * sum;
        }
        return ret;
    }
}

