/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.exif;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.jpeg.exif.ExifBaseTest;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AsciiFieldTest
extends ExifBaseTest {
    @Test
    public void testSingleImage() throws Exception {
        File imageFile = this.getTestImageByName("Canon Powershot SD750 - 2007.12.26.n.IMG_3704.JPG");
        ImageMetadata metadata = Imaging.getMetadata((File)imageFile);
        Assertions.assertNotNull((Object)metadata);
        JpegImageMetadata jpegMetadata = (JpegImageMetadata)metadata;
        TiffImageMetadata exif = jpegMetadata.getExif();
        List fields = exif.getAllFields();
        HashMap<Integer, TiffField> fieldMap = new HashMap<Integer, TiffField>();
        for (TiffField field : fields) {
            fieldMap.put(field.getTag(), field);
        }
        HashMap<Integer, String> expectedFieldValues = new HashMap<Integer, String>();
        expectedFieldValues.put(TiffTagConstants.TIFF_TAG_MAKE.tag, "Canon");
        expectedFieldValues.put(TiffTagConstants.TIFF_TAG_MODEL.tag, "Canon PowerShot SD750");
        expectedFieldValues.put(TiffTagConstants.TIFF_TAG_DATE_TIME.tag, "2007:12:25 13:34:39");
        for (Map.Entry tag : expectedFieldValues.entrySet()) {
            Assertions.assertTrue((boolean)fieldMap.containsKey(tag.getKey()));
            TiffField field = (TiffField)fieldMap.get(tag.getKey());
            Assertions.assertNotNull((Object)field);
            Object value = field.getValue();
            Assertions.assertNotNull((Object)value);
            Assertions.assertEquals((Object)value, tag.getValue());
        }
    }
}

