/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.exif;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.ImagingTest;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.common.bytesource.ByteSourceFile;
import org.apache.commons.imaging.formats.jpeg.JpegImageParser;

public abstract class ExifBaseTest
extends ImagingTest {
    private static final ImagingTest.ImageFilter HAS_EXIF_IMAGE_FILTER = ExifBaseTest::hasExifData;
    private static final ImagingTest.ImageFilter JPEG_IMAGE_FILTER = file -> file.getName().toLowerCase().endsWith(".jpg");

    protected static boolean hasExifData(File file) {
        if (!file.getName().toLowerCase().endsWith(".jpg")) {
            return false;
        }
        try {
            ByteSourceFile byteSource = new ByteSourceFile(file);
            return new JpegImageParser().hasExifSegment((ByteSource)byteSource);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected File getImageWithExifData() throws IOException, ImageReadException {
        return this.getTestImage(HAS_EXIF_IMAGE_FILTER);
    }

    protected static List<File> getImagesWithExifData() throws IOException, ImageReadException {
        return ExifBaseTest.getTestImages(HAS_EXIF_IMAGE_FILTER);
    }

    protected static List<File> getJpegImages() throws IOException, ImageReadException {
        return ExifBaseTest.getTestImages(JPEG_IMAGE_FILTER);
    }
}

