/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.exif;

import java.io.File;
import java.util.stream.Stream;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.common.bytesource.ByteSourceFile;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.jpeg.JpegImagingParameters;
import org.apache.commons.imaging.formats.jpeg.JpegUtils;
import org.apache.commons.imaging.formats.jpeg.exif.ExifBaseTest;
import org.apache.commons.imaging.internal.Debug;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class ExifDumpTest
extends ExifBaseTest {
    public static Stream<File> data() throws Exception {
        return ExifDumpTest.getImagesWithExifData().stream();
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testDumpJFIF(File imageFile) throws Exception {
        ByteSourceFile byteSource = new ByteSourceFile(imageFile);
        Debug.debug((String)"Segments:");
        new JpegUtils().dumpJFIF((ByteSource)byteSource);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testMetadata(File imageFile) throws Exception {
        JpegImagingParameters params = new JpegImagingParameters();
        JpegImageMetadata metadata = (JpegImageMetadata)Imaging.getMetadata((File)imageFile);
        Assertions.assertNotNull((Object)metadata);
    }
}

