/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.exif;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.common.bytesource.ByteSourceArray;
import org.apache.commons.imaging.common.bytesource.ByteSourceFile;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.jpeg.JpegUtils;
import org.apache.commons.imaging.formats.jpeg.exif.ExifBaseTest;
import org.apache.commons.imaging.formats.jpeg.exif.ExifRewriter;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldType;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSet;
import org.apache.commons.imaging.internal.Debug;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExifRewriteTest
extends ExifBaseTest {
    @Test
    public void testRemove() throws Exception {
        List<File> images = ExifRewriteTest.getImagesWithExifData();
        for (File imageFile : images) {
            Debug.debug((String)"imageFile", (Object)imageFile);
            boolean ignoreImageData = this.isPhilHarveyTestImage(imageFile);
            if (ignoreImageData) continue;
            ByteSourceFile byteSource = new ByteSourceFile(imageFile);
            Debug.debug((String)"Source Segments:");
            new JpegUtils().dumpJFIF((ByteSource)byteSource);
            JpegImageMetadata metadata = (JpegImageMetadata)Imaging.getMetadata((File)imageFile);
            Assertions.assertNotNull((Object)metadata);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            new ExifRewriter().removeExifMetadata((ByteSource)byteSource, (OutputStream)baos);
            byte[] bytes = baos.toByteArray();
            File tempFile = File.createTempFile("test", ".jpg");
            Debug.debug((String)"tempFile", (Object)tempFile);
            FileUtils.writeByteArrayToFile((File)tempFile, (byte[])bytes);
            Debug.debug((String)"Output Segments:");
            new JpegUtils().dumpJFIF((ByteSource)new ByteSourceArray(bytes));
            Assertions.assertFalse((boolean)ExifRewriteTest.hasExifData(tempFile));
        }
    }

    @Test
    public void testInsert() throws Exception {
        List<File> images = ExifRewriteTest.getImagesWithExifData();
        for (File imageFile : images) {
            Debug.debug((String)"imageFile", (Object)imageFile);
            boolean ignoreImageData = this.isPhilHarveyTestImage(imageFile);
            if (ignoreImageData) continue;
            ByteSourceFile byteSource = new ByteSourceFile(imageFile);
            Debug.debug((String)"Source Segments:");
            new JpegUtils().dumpJFIF((ByteSource)byteSource);
            JpegImageMetadata originalMetadata = (JpegImageMetadata)Imaging.getMetadata((File)imageFile);
            Assertions.assertNotNull((Object)originalMetadata);
            TiffImageMetadata oldExifMetadata = originalMetadata.getExif();
            Assertions.assertNotNull((Object)oldExifMetadata);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            new ExifRewriter().removeExifMetadata((ByteSource)byteSource, (OutputStream)baos);
            byte[] bytes = baos.toByteArray();
            File tempFile = File.createTempFile("removed", ".jpg");
            Debug.debug((String)"tempFile", (Object)tempFile);
            FileUtils.writeByteArrayToFile((File)tempFile, (byte[])bytes);
            Debug.debug((String)"Output Segments:");
            ByteSourceArray stripped = new ByteSourceArray(bytes);
            new JpegUtils().dumpJFIF((ByteSource)stripped);
            Assertions.assertFalse((boolean)ExifRewriteTest.hasExifData(tempFile));
            TiffOutputSet outputSet = oldExifMetadata.getOutputSet();
            ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
            new ExifRewriter().updateExifMetadataLossy((ByteSource)stripped, (OutputStream)baos2, outputSet);
            byte[] bytes2 = baos2.toByteArray();
            File tempFile2 = File.createTempFile("inserted_", ".jpg");
            Debug.debug((String)"tempFile", (Object)tempFile2);
            FileUtils.writeByteArrayToFile((File)tempFile2, (byte[])bytes2);
            Debug.debug((String)"Output Segments:");
            new JpegUtils().dumpJFIF((ByteSource)new ByteSourceArray(bytes2));
            JpegImageMetadata newMetadata = (JpegImageMetadata)Imaging.getMetadata((File)tempFile2);
            Assertions.assertNotNull((Object)newMetadata);
            TiffImageMetadata newExifMetadata = newMetadata.getExif();
            Assertions.assertNotNull((Object)newExifMetadata);
            this.compare(imageFile, oldExifMetadata, newExifMetadata);
        }
    }

    private void rewrite(Rewriter rewriter, String name) throws IOException, ImageReadException {
        List<File> images = ExifRewriteTest.getImagesWithExifData();
        for (File imageFile : images) {
            try {
                Debug.debug((String)"imageFile", (Object)imageFile);
                boolean ignoreImageData = this.isPhilHarveyTestImage(imageFile);
                if (ignoreImageData) continue;
                ByteSourceFile byteSource = new ByteSourceFile(imageFile);
                Debug.debug((String)"Source Segments:");
                new JpegUtils().dumpJFIF((ByteSource)byteSource);
                JpegImageMetadata oldMetadata = (JpegImageMetadata)Imaging.getMetadata((File)imageFile);
                if (null == oldMetadata) continue;
                Assertions.assertNotNull((Object)oldMetadata);
                TiffImageMetadata oldExifMetadata = oldMetadata.getExif();
                if (null == oldExifMetadata) continue;
                Assertions.assertNotNull((Object)oldExifMetadata);
                oldMetadata.dump();
                TiffOutputSet outputSet = oldExifMetadata.getOutputSet();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                rewriter.rewrite((ByteSource)byteSource, baos, outputSet);
                byte[] bytes = baos.toByteArray();
                File tempFile = File.createTempFile(name + "_", ".jpg");
                Debug.debug((String)"tempFile", (Object)tempFile);
                FileUtils.writeByteArrayToFile((File)tempFile, (byte[])bytes);
                Debug.debug((String)"Output Segments:");
                new JpegUtils().dumpJFIF((ByteSource)new ByteSourceArray(bytes));
                JpegImageMetadata newMetadata = (JpegImageMetadata)Imaging.getMetadata((File)tempFile);
                Assertions.assertNotNull((Object)newMetadata);
                TiffImageMetadata newExifMetadata = newMetadata.getExif();
                Assertions.assertNotNull((Object)newExifMetadata);
                this.compare(imageFile, oldExifMetadata, newExifMetadata);
            }
            catch (IOException | ImageReadException e) {
                Debug.debug((String)"imageFile", (Object)imageFile.getAbsoluteFile());
                Debug.debug((Throwable)e);
                throw e;
            }
            catch (ImageWriteException e) {
                Debug.debug((String)"imageFile", (Object)imageFile.getAbsoluteFile());
                Debug.debug((Throwable)e);
            }
        }
    }

    @Test
    public void testRewriteLossy() throws Exception {
        Rewriter rewriter = (byteSource, os, outputSet) -> new ExifRewriter().updateExifMetadataLossy(byteSource, os, outputSet);
        this.rewrite(rewriter, "lossy");
    }

    @Test
    public void testRewriteLossless() throws Exception {
        Rewriter rewriter = (byteSource, os, outputSet) -> new ExifRewriter().updateExifMetadataLossless(byteSource, os, outputSet);
        this.rewrite(rewriter, "lossless");
    }

    private Map<Integer, TiffImageMetadata.Directory> makeDirectoryMap(List<? extends ImageMetadata.ImageMetadataItem> directories) {
        HashMap<Integer, TiffImageMetadata.Directory> directoryMap = new HashMap<Integer, TiffImageMetadata.Directory>();
        for (ImageMetadata.ImageMetadataItem imageMetadataItem : directories) {
            TiffImageMetadata.Directory directory = (TiffImageMetadata.Directory)imageMetadataItem;
            directoryMap.put(directory.type, directory);
        }
        return directoryMap;
    }

    private Map<Integer, TiffField> makeFieldMap(List<? extends ImageMetadata.ImageMetadataItem> items) {
        HashMap<Integer, TiffField> fieldMap = new HashMap<Integer, TiffField>();
        for (ImageMetadata.ImageMetadataItem imageMetadataItem : items) {
            TiffImageMetadata.TiffMetadataItem item = (TiffImageMetadata.TiffMetadataItem)imageMetadataItem;
            TiffField field = item.getTiffField();
            if (fieldMap.containsKey(field.getTag())) continue;
            fieldMap.put(field.getTag(), field);
        }
        return fieldMap;
    }

    private void compare(File imageFile, TiffImageMetadata oldExifMetadata, TiffImageMetadata newExifMetadata) throws ImageReadException {
        Assertions.assertNotNull((Object)oldExifMetadata);
        Assertions.assertNotNull((Object)newExifMetadata);
        List oldDirectories = oldExifMetadata.getDirectories();
        List newDirectories = newExifMetadata.getDirectories();
        Assertions.assertEquals((int)oldDirectories.size(), (int)newDirectories.size());
        Map<Integer, TiffImageMetadata.Directory> oldDirectoryMap = this.makeDirectoryMap(oldDirectories);
        Map<Integer, TiffImageMetadata.Directory> newDirectoryMap = this.makeDirectoryMap(newDirectories);
        Assertions.assertEquals((int)oldDirectories.size(), (int)oldDirectoryMap.size());
        ArrayList<Integer> oldDirectoryTypes = new ArrayList<Integer>(oldDirectoryMap.keySet());
        oldDirectoryTypes.sort(null);
        ArrayList<Integer> newDirectoryTypes = new ArrayList<Integer>(newDirectoryMap.keySet());
        newDirectoryTypes.sort(null);
        Assertions.assertEquals(oldDirectoryTypes, newDirectoryTypes);
        for (Integer dirType : oldDirectoryTypes) {
            TiffImageMetadata.Directory oldDirectory = oldDirectoryMap.get(dirType);
            TiffImageMetadata.Directory newDirectory = newDirectoryMap.get(dirType);
            Assertions.assertNotNull((Object)oldDirectory);
            Assertions.assertNotNull((Object)newDirectory);
            List oldItems = oldDirectory.getItems();
            List newItems = newDirectory.getItems();
            Map<Integer, TiffField> oldFieldMap = this.makeFieldMap(oldItems);
            Map<Integer, TiffField> newFieldMap = this.makeFieldMap(newItems);
            HashSet<Integer> missingInNew = new HashSet<Integer>(oldFieldMap.keySet());
            missingInNew.removeAll(newFieldMap.keySet());
            HashSet<Integer> missingInOld = new HashSet<Integer>(newFieldMap.keySet());
            missingInOld.removeAll(oldFieldMap.keySet());
            Assertions.assertTrue((boolean)missingInNew.isEmpty());
            Assertions.assertTrue((boolean)missingInOld.isEmpty());
            Assertions.assertEquals((int)oldItems.size(), (int)oldFieldMap.size());
            Assertions.assertEquals(oldFieldMap.keySet(), newFieldMap.keySet());
            Assertions.assertEquals(oldFieldMap.keySet(), newFieldMap.keySet());
            ArrayList<Integer> oldFieldTags = new ArrayList<Integer>(oldFieldMap.keySet());
            oldFieldTags.sort(null);
            ArrayList<Integer> newFieldTags = new ArrayList<Integer>(newFieldMap.keySet());
            newFieldTags.sort(null);
            Assertions.assertEquals(oldFieldTags, newFieldTags);
            for (Integer fieldTag : oldFieldTags) {
                TiffField oldField = oldFieldMap.get(fieldTag);
                TiffField newField = newFieldMap.get(fieldTag);
                Assertions.assertNotNull((Object)oldField);
                Assertions.assertNotNull((Object)newField);
                Assertions.assertEquals((int)oldField.getTag(), (int)newField.getTag());
                Assertions.assertEquals((int)dirType, (int)newField.getDirectoryType());
                Assertions.assertEquals((int)oldField.getDirectoryType(), (int)newField.getDirectoryType());
                if (oldField.getFieldType() == FieldType.ASCII) {
                    byte[] rawBytes = oldField.getByteArrayValue();
                    boolean hasInvalidByte = false;
                    for (byte rawByte : rawBytes) {
                        if ((rawByte & 0x80) == 0) continue;
                        hasInvalidByte = true;
                        break;
                    }
                    if (hasInvalidByte) continue;
                }
                Assertions.assertEquals((long)oldField.getCount(), (long)newField.getCount());
                Assertions.assertEquals((Object)oldField.isLocalValue(), (Object)newField.isLocalValue());
                if (oldField.getTag() == 514 || oldField.getTagInfo().isOffset() || oldField.getTagInfo().isText()) continue;
                if (oldField.isLocalValue()) {
                    if (oldField.getTag() == 278 || oldField.getTag() == 279) {
                        Assertions.assertEquals((Object)oldField.getValue(), (Object)newField.getValue());
                        continue;
                    }
                    Assertions.assertEquals((int)oldField.getBytesLength(), (int)newField.getBytesLength());
                    Assertions.assertArrayEquals((byte[])oldField.getByteArrayValue(), (byte[])newField.getByteArrayValue());
                    continue;
                }
                Assertions.assertArrayEquals((byte[])oldField.getByteArrayValue(), (byte[])newField.getByteArrayValue());
            }
        }
    }

    private static interface Rewriter {
        public void rewrite(ByteSource var1, OutputStream var2, TiffOutputSet var3) throws ImageReadException, IOException, ImageWriteException;
    }
}

