/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.exif;

import java.io.File;
import java.util.stream.Stream;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.jpeg.exif.ExifBaseTest;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.internal.Debug;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class GpsTest
extends ExifBaseTest {
    public static Stream<File> data() throws Exception {
        return GpsTest.getImagesWithExifData().stream();
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void test(File imageFile) throws Exception {
        if (imageFile.getParentFile().getName().toLowerCase().equals("@broken")) {
            return;
        }
        JpegImageMetadata metadata = (JpegImageMetadata)Imaging.getMetadata((File)imageFile);
        if (null == metadata) {
            return;
        }
        TiffImageMetadata exifMetadata = metadata.getExif();
        if (null == exifMetadata) {
            return;
        }
        TiffImageMetadata.GPSInfo gpsInfo = exifMetadata.getGPS();
        if (null == gpsInfo) {
            return;
        }
        Debug.debug((String)("imageFile " + imageFile));
        Debug.debug((String)("gpsInfo " + gpsInfo));
        Debug.debug((String)("gpsInfo longitude as degrees east " + gpsInfo.getLongitudeAsDegreesEast()));
        Debug.debug((String)("gpsInfo latitude as degrees north " + gpsInfo.getLatitudeAsDegreesNorth()));
        Debug.debug();
    }
}

