/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.exif;

import java.io.File;
import java.util.stream.Stream;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.common.bytesource.ByteSourceFile;
import org.apache.commons.imaging.examples.WriteExifMetadataExample;
import org.apache.commons.imaging.formats.jpeg.JpegImageParser;
import org.apache.commons.imaging.formats.jpeg.exif.ExifBaseTest;
import org.apache.commons.imaging.formats.jpeg.exif.ExifRewriter;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.internal.Debug;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class WriteExifMetadataExampleTest
extends ExifBaseTest {
    public static Stream<File> data() throws Exception {
        return WriteExifMetadataExampleTest.getJpegImages().stream();
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testOddOffsets(File imageFile) throws Exception {
        Debug.debug((String)"imageFile", (Object)imageFile.getAbsoluteFile());
        File tempFile = File.createTempFile("test", ".jpg");
        Debug.debug((String)"tempFile", (Object)tempFile.getAbsoluteFile());
        try {
            boolean ignoreImageData = this.isPhilHarveyTestImage(imageFile);
            if (ignoreImageData) {
                return;
            }
            new WriteExifMetadataExample().changeExifMetadata(imageFile, tempFile);
            JpegImageParser parser = new JpegImageParser();
            ByteSourceFile byteSource = new ByteSourceFile(tempFile);
            TiffImageMetadata tiff = parser.getExifMetadata((ByteSource)byteSource, null);
            for (TiffField tiffField : tiff.getAllFields()) {
                if (tiffField.isLocalValue()) continue;
                boolean isOdd = ((long)tiffField.getOffset() & 1L) == 0L;
                Assertions.assertTrue((boolean)isOdd);
            }
        }
        catch (ExifRewriter.ExifOverflowException e) {
            Debug.debug((String)("Ignoring unavoidable ExifOverflowException: " + e.getMessage()));
            Debug.debug((String)("Error image: " + imageFile.getAbsoluteFile()));
        }
    }
}

