/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.iptc;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.common.bytesource.ByteSourceFile;
import org.apache.commons.imaging.formats.jpeg.JpegImageParser;
import org.apache.commons.imaging.formats.jpeg.JpegImagingParameters;
import org.apache.commons.imaging.formats.jpeg.JpegPhotoshopMetadata;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcBaseTest;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcRecord;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcType;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcTypes;
import org.apache.commons.imaging.formats.jpeg.iptc.JpegIptcRewriter;
import org.apache.commons.imaging.formats.jpeg.iptc.PhotoshopApp13Data;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class IptcAddTest
extends IptcBaseTest {
    public static Stream<File> data() throws Exception {
        return IptcAddTest.getJpegImages().stream();
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testAddIptcData(File imageFile) throws Exception {
        ByteSourceFile byteSource = new ByteSourceFile(imageFile);
        JpegImagingParameters params = new JpegImagingParameters();
        JpegPhotoshopMetadata metadata = new JpegImageParser().getPhotoshopMetadata((ByteSource)byteSource, params);
        if (metadata == null) {
            return;
        }
        ArrayList newBlocks = new ArrayList(metadata.photoshopApp13Data.getNonIptcBlocks());
        List oldRecords = metadata.photoshopApp13Data.getRecords();
        ArrayList<IptcRecord> newRecords = new ArrayList<IptcRecord>();
        for (IptcRecord record : oldRecords) {
            if (record.iptcType == IptcTypes.CITY || record.iptcType == IptcTypes.CREDIT) continue;
            newRecords.add(record);
        }
        newRecords.add(new IptcRecord((IptcType)IptcTypes.CITY, "Albany, NY"));
        newRecords.add(new IptcRecord((IptcType)IptcTypes.CREDIT, "William Sorensen"));
        PhotoshopApp13Data newData = new PhotoshopApp13Data(newRecords, newBlocks);
        File updated = File.createTempFile(imageFile.getName() + ".iptc.add.", ".jpg");
        try (FileOutputStream fos = new FileOutputStream(updated);
             BufferedOutputStream os = new BufferedOutputStream(fos);){
            new JpegIptcRewriter().writeIPTC((ByteSource)byteSource, (OutputStream)os, newData);
        }
        ByteSourceFile updateByteSource = new ByteSourceFile(updated);
        JpegPhotoshopMetadata outMetadata = new JpegImageParser().getPhotoshopMetadata((ByteSource)updateByteSource, params);
        Assertions.assertNotNull((Object)outMetadata);
        Assertions.assertEquals((int)outMetadata.getItems().size(), (int)newRecords.size());
    }
}

