/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.iptc;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.ImagingTest;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.common.bytesource.ByteSourceFile;
import org.apache.commons.imaging.formats.jpeg.JpegImageParser;

public abstract class IptcBaseTest
extends ImagingTest {
    private static final ImagingTest.ImageFilter HAS_IPTC_IMAGE_FILTER = IptcBaseTest::hasIptcData;
    private static final ImagingTest.ImageFilter JPEG_IMAGE_FILTER = file -> file.getName().toLowerCase().endsWith(".jpg");

    protected static boolean hasIptcData(File file) {
        if (!file.getName().toLowerCase().endsWith(".jpg")) {
            return false;
        }
        try {
            ByteSourceFile byteSource = new ByteSourceFile(file);
            return new JpegImageParser().hasIptcSegment((ByteSource)byteSource);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected File getImageWithIptcData() throws IOException, ImageReadException {
        return this.getTestImage(HAS_IPTC_IMAGE_FILTER);
    }

    protected static List<File> getImagesWithIptcData() throws IOException, ImageReadException {
        return IptcBaseTest.getTestImages(HAS_IPTC_IMAGE_FILTER);
    }

    protected List<File> getImagesWithIptcData(int max) throws IOException, ImageReadException {
        return IptcBaseTest.getTestImages(HAS_IPTC_IMAGE_FILTER, max);
    }

    protected File getJpegImage() throws IOException, ImageReadException {
        return this.getTestImage(JPEG_IMAGE_FILTER);
    }

    protected static List<File> getJpegImages() throws IOException, ImageReadException {
        return IptcBaseTest.getTestImages(JPEG_IMAGE_FILTER);
    }

    protected List<File> getJpegImages(int max) throws IOException, ImageReadException {
        return IptcBaseTest.getTestImages(JPEG_IMAGE_FILTER, max);
    }
}

